% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_weight_gp.R
\name{compute_weight_gp}
\alias{compute_weight_gp}
\title{Calculate weights for estimation of a point on CERF}
\usage{
compute_weight_gp(
  w,
  w_obs,
  scaled_obs,
  hyperparam,
  inv_sigma_obs,
  GPS_m,
  est_sd = FALSE,
  kernel_fn = function(x) exp(-x^2)
)
}
\arguments{
\item{w}{A scalar of exposure level of interest.}

\item{w_obs}{A vector of observed exposure levels of all samples.}

\item{scaled_obs}{A matrix of two columns.
\itemize{
\item First column is the scaled GPS value of all samples
(GPS * 1 / sqrt(alpha))
\item Second column is the scaled exposure value of all samples
(w * 1/sqrt(beta))
}}

\item{hyperparam}{A vector of hyper-parameters for the GP.
\itemize{
\item First element: alpha
\item Second element: beta
\item Third element: gamma/sigma
}}

\item{inv_sigma_obs}{Inverse of the covariance matrix between observed
samples.}

\item{GPS_m}{A data.frame of GPS vectors.
\itemize{
\item Column 1: A vector of estimated GPS evaluated at the observed exposure
levels.
\item Column 2: Estimated conditional means of the exposure given covariates
for all samples (e_gps_pred).
\item Column 3: Estimated conditional standard deviation of the exposure given
covariates for all samples (e_gps_std).
}}

\item{est_sd}{Should the posterior se be computed (default=FALSE)}

\item{kernel_fn}{The covariance function of GP.}
}
\value{
A list of two elements, weight and standard deviation.
}
\description{
Calculates the weights of observed outcomes which is then used to estimate
the posterior mean of CERF at a given exposure level.
}
\keyword{internal}
