% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern}
\alias{matern}
\title{The Matérn correlation function proposed by Matérn (1960)}
\usage{
matern(d, range, nu)
}
\arguments{
\item{d}{a matrix of distances}

\item{range}{a numerical value containing the range parameter}

\item{nu}{a numerical value containing the smoothness parameter}
}
\value{
a numerical matrix
}
\description{
This function computes the Matérn correlation function given
a distance matrix. The Matérn correlation function is given by
\deqn{C(h)=\frac{2^{1-\nu}}{\Gamma(\nu)} \left(\frac{h}{\phi} \right)^{\nu} 
\mathcal{K}_{\nu}\left( \frac{h}{\phi} \right),}
where \eqn{\phi} is the range parameter. \eqn{\nu} is the smoothness parameter. 
\eqn{\mathcal{K}_{\nu}(\cdot)} is the modified Bessel function of the second kind of order \eqn{\nu}.
The form of covariance includes the following special cases by specifying \eqn{\nu} to be 0.5, 1.5, 2.5.
\itemize{
\item{\eqn{\nu=0.5} corresponds to the  exponential correlation function (\strong{exp}) 
of the form
\deqn{C(h) = \exp\left\{ - \frac{h}{\phi} \right\} }
}
\item{\eqn{\nu=1.5} corresponds to the Matérn correlation function with smoothness parameter 1.5 (\strong{matern_3_2}) 
of the form
\deqn{C(h) = \left( 1 + \frac{h}{\phi} \right) \exp\left\{ - \frac{h}{\phi} \right\} }
}
\item{\eqn{\nu=2.5} corresponds to the Matérn correlation function with smoothness parameter 2.5 (\strong{matern_5_2}) 
of the form
\deqn{C(h) = \left\{ 1 + \frac{h}{\phi}  + \frac{1}{3}\left(\frac{h}{\phi}\right)^2 \right\} \exp\left\{ - \frac{h}{\phi} \right\} }
}
}
}
\seealso{
\link{GPBayes-package}, \code{\link{GaSP}}, \linkS4class{gp}, \code{\link{CH}}, \code{\link{kernel}}, \code{\link{ikernel}}
}
\author{
Pulong Ma \email{mpulong@gmail.com}
}
