% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ts.ng.trt.int.oc.df.r
\name{get.ts.ng.trt.int.oc.df}
\alias{get.ts.ng.trt.int.oc.df}
\title{Get two-sample normal-gamma interim OC curve data.frame}
\usage{
get.ts.ng.trt.int.oc.df(
  mu.0.t = 0,
  n.0.t = 1e-04,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  mu.0.c = 0,
  n.0.c = 10,
  alpha.0.c = 2.5,
  beta.0.c = 10,
  Delta.lrv = 1.5,
  Delta.tv = 3,
  mu.c = 0.25,
  s.t = 1.5,
  s.c = 1.5,
  npointsLookup = 20,
  npoints = 20,
  n.MC.lookup = 500,
  n.MC = 500,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  n.int.t = c(27, 40),
  n.int.c = c(27, 40),
  final.n.t = 55,
  final.n.c = 55,
  go.thresh = 0.6,
  ng.thresh = 0.6,
  go.parallel = TRUE,
  cl = cl,
  seed = 1234,
  include_nogo = TRUE
)
}
\arguments{
\item{mu.0.t}{prior mean for treatment group}

\item{n.0.t}{prior effective sample size parameter for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{mu.0.c}{prior mean for control group}

\item{n.0.c}{prior effective sample size parameter for control group}

\item{alpha.0.c}{prior alpha parameter for control group}

\item{beta.0.c}{prior beta parameter for control group}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{mu.c}{assumed mean for control group}

\item{s.t}{treatment standard deviation}

\item{s.c}{control standard deviation}

\item{npointsLookup}{number of points for lookup table}

\item{npoints}{number of points to run simulations}

\item{n.MC.lookup}{number of trials used for lookup table}

\item{n.MC}{number of trials run at each point}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{n.int.t}{interim sample sizes for treatment arm}

\item{n.int.c}{interim sample sizes for control arm}

\item{final.n.t}{final sample size: treatment arm}

\item{final.n.c}{final sample sizE: control arm}

\item{go.thresh}{interim predictive probability threshold for go}

\item{ng.thresh}{interim predictive probability threshold for no-go}

\item{go.parallel}{logical for parallel processing}

\item{cl}{cl}

\item{seed}{random seed}

\item{include_nogo}{logical}
}
\value{
A data.frame is returned.
}
\description{
Get two-sample normal-gamma interim OC curve data.frame
}
\examples{
\donttest{
my.ts.ng.trt.int.oc.df <- get.ts.ng.trt.int.oc.df(npointsLookup = 2, npoints=3, n.MC.lookup=5,
n.MC=5, go.parallel=FALSE)
}
}
