% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbeta.rp.r
\name{Reparameterized.beta}
\alias{Reparameterized.beta}
\alias{dbeta.rp}
\alias{pbeta.rp}
\alias{qbeta.rp}
\title{Reparameterized Beta distribution functions}
\usage{
dbeta.rp(x, mean = 0.5, effective.ss = 1, ncp = 0, log = FALSE)

pbeta.rp(
  q,
  mean = 0.5,
  effective.ss = 1,
  ncp = 0,
  lower.tail = TRUE,
  log.p = FALSE
)

qbeta.rp(
  p,
  mean = 0.5,
  effective.ss = 1,
  ncp = 0,
  lower.tail = TRUE,
  log.p = FALSE
)
}
\arguments{
\item{x}{likelihood function evaluates at point x}

\item{mean}{mean}

\item{effective.ss}{effective sample size}

\item{ncp}{non-centrality parameter}

\item{log}{as in stats::*beta}

\item{q}{quantile}

\item{lower.tail}{logical; if TRUE (default), probabilities are P(X < x), otherwise, P(X>x).}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p)}

\item{p}{cumulative probability}
}
\value{
Returns density values, cumulative probabilities, quantiles and random samples from a Beta distribution.
}
\description{
Reparameterized Beta distribution functions
}
\examples{
dbeta.rp(.5, .5, 1)
pbeta.rp(.5, .5, 1)
qbeta.rp(.975, .5, 1)
}
