% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Discrete_CM}
\alias{Discrete_CM}
\title{Family of models for Discrete Choice}
\usage{
Discrete_CM(
  formula = NaN,
  case_id = "a",
  alternatives = "a",
  reference = NaN,
  alternative_specific = NA_character_,
  data = c(1, NA, NaN, Inf, -Inf),
  distribution = "a",
  freedom_degrees = 1,
  intercept = "standard"
)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit. An expression of the form y ~ predictors is interpreted as a specification that the response y is modelled by a linear predictor specified symbolically by model. A particularity for the formula is that for the case-specific variables, the user can define a specific effect for a category.}

\item{case_id}{a string with the name of the column that identifies each case.}

\item{alternatives}{a string with the name of the column that identifies the vector of alternatives the individual could have chosen.}

\item{reference}{a string indicating the reference category}

\item{alternative_specific}{a character vector with the name of the explanatory variables that are different for each case, these are the alternative specific variables. By default, the case specific variables are the explanatory variables that are not identify in here, but that are part of the formula.}

\item{data}{a dataframe object in R, with the dependent variable as factor.}

\item{distribution}{a string indicating the F distribution, options are: logistic, normal, cauchit, student (any df), gompertz, gumbel.}

\item{freedom_degrees}{an optional scalar to indicate the degrees of freedom for the Student distribution.}

\item{intercept}{if "conditional" then the design will be equivalent to the conditional logit model}
}
\description{
Discrete choice model: Requires data in long form.
For each individual (or decision maker), there are multiple observations (rows),
one for each of the alternatives the individual could have chosen.
We call the group of observations for an individual a “case”.
Each case represents a single statistical observation although it comprises
multiple observations.
}
\note{
For these models it is not allowed to exclude the intercept.
}
\examples{
library(GLMcat)
data(TravelChoice)
Discrete_CM(formula = choice ~ hinc + gc + invt,
case_id = "indv",alternatives = "mode",reference = "air",
data = TravelChoice,  alternative_specific = c("gc", "invt"),
distribution = "logistic")
}
