\name{random.unit}
\alias{random.unit}

\title{Compute the Sunject-Specific Coefficients in the Structural Form of GLMM-AR(p)}
\description{
This functions recovers the subject-specific random-effect coefficients from the reduced 
form estimates. This function is used when the \eqn{\beta_{2i}}{\beta_{2i}} does not only include a 
random intercept.
}
 \usage{
   random.unit(y, X1, Wi, St, Ai, Ft, Unit.Index, Time.Index, unitint,  model)
 }

\arguments{
    \item{y}{A vector of the dichotomous responses, taking two unique values of 0 and 1.}

    \item{X1}{A matrix of covariates with fixed effects.}

    \item{Wi}{A matrix of covariates with subject-varying effects.}

    \item{St}{A matrix of covariates with time-varying effects.}

    \item{Ai}{A matrix of group-level predictors explaining the subject-varying effects.
               The number of rows of this matrix is equal to the length of y. If some or 
               all predictors are time-varying, the function will automatically use the 
               within-subject mean; for time-invariant predictors, they should be repeated 
               over the same times of each subject. The default is "NULL", and there are 
               no group-level covariates.}
   
    \item{Ft}{A matrix of group-level predictors explaining the time-varying effects.
	       The number of rows of this matrix is equal to the length of y. If some or
               all predictors are subject-varying, the function will automatically use the
               within-time-period mean; for subject-invariant predictors, they should be repeated
               over the same number of subjects in the specific time period.
               The default is "NULL", and there are no group-level covariates.}

    \item{Unit.Index}{A vector of the subject index,i.e., the i's. Note: the number of
                observations of each unit should be larger than the lag order, nlag. Those
                units which have fewer than or equal to nlag observations should be taken
                out of the sample in order to use the function.}

    \item{Time.Index}{A vector of the time index, i.e., the t's. Note: no missing observations
               in the middle of the sample time periods of a unit are allowed. In other words,
               unbalanced data structures are allowed, but no broken data structure.}

    \item{unitint}{Is a subject-specific intercept added into the model?} 
             
    \item{model}{The MCMC output generated by the full MCMC by using the function 
                of \code{GLMMARp.Binary}.}
}

\value{
   A matrix with the row dimension equal to the number of iterations returned from 
   \code{GLMMARp.Binary}; with the column dimension equal to the number of variables, 
   \eqn{W}{W}, times the number of sample subjects, \eqn{N}{N}.
}

\examples{
\dontrun{
## Example 1: Compute uni-specific random effects 
 data(StateFailure)
 require(bayesSurv)
 data(StateFailure)
 y<-StateFailure$failure
 Unit<-StateFailure$country
 Time<-StateFailure$year
 Fixed<-cbind(StateFailure$poldemoc,  StateFailure$bnkv123, StateFailure$bnkv117,
              StateFailure$poldurab, StateFailure$faocalry, StateFailure$pwtcgdp,
              StateFailure$macnac,StateFailure$macnciv,  StateFailure$wdiinfmt,
              StateFailure$ptsamnes, StateFailure$dis1, StateFailure$bnkv81,
              StateFailure$change.demo)
 
 UnitRandom<-cbind(log(StateFailure$pwtopen))
 TimeRandom<-as.matrix(rep( 1, length(y)))
 UnitPred<-cbind(StateFailure$macnac, StateFailure$poldemoc)
 TimePred<-"NULL"
 data(StateAR2)
 betai <- random.unit (y=y,X1=Fixed, Wi=UnitRandom, St=TimeRandom, Ai=UnitPred, Ft=TimePred,
                        Unit.Index=Unit, Time.Index=Time, model=StateAR2, unitint=1)
}
}
\keyword{manip}
