% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare.R
\name{ggm_compare}
\alias{ggm_compare}
\title{Compare Gaussian Graphical Models}
\usage{
ggm_compare(Yg1, Yg2, method = "spearman", alpha = 0.05)
}
\arguments{
\item{Yg1}{The data matrix of dimensions \emph{n} (observations) by \emph{p} (nodes) for
group one.}

\item{Yg2}{The data matrix of dimensions \emph{n} (observations) by \emph{p} (nodes) for
group two.}

\item{method}{Character string. Which type of correlation coefficients
to be computed. Options include \code{"pearson"} (default),
\code{"kendall"}, \code{"spearman"}, and \code{"polychoric"}.}

\item{alpha}{The desired significance level (defaults to \code{0.05}). Note that
1 - alpha corresponds to specificity.}
}
\value{
An object of class \code{ggm_compare}
}
\description{
Compare Gaussian Graphical Models
}
\examples{
\donttest{
# data

Yg1 <- na.omit(subset(bfi, gender == 1)[,1:10])
Yg2 <- na.omit(subset(bfi, gender == 2)[,1:10])

# compare relations
fit <- ggm_compare(Yg1, Yg2)
}
}
