% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustComponents.R
\name{robustComponents}
\alias{robustComponents}
\title{Robust GFA components}
\usage{
robustComponents(models, corThr = 0.9, matchThr = 0.5)
}
\arguments{
\item{models}{Either a vector containing the file names, where the models are
saved as 'res', or a list containing the models.}

\item{corThr}{How close two components are required to be, in terms of
correlation, in order to match them.}

\item{matchThr}{How big proportion of the chains need to contain the
component to include it in the robust components.}
}
\value{
A list with the following elements (when input data are paired in two
  modes, the returned list is of length 2, containing the following elements
  for each mode):
\item{Krobust}{The number of robust components found with the given
  thresholds.}
\item{effect}{The component effect in the data space; and array of size
  \eqn{N \times \sum_{m=1}^M D_m \times Krobust.}}
\item{indices}{The corresponding component indices; a \eqn{length(models)
  \times Krobust} matrix. Negative indices denote the closest component in
  the corresponding repetition, having no components above the threshold.}
\item{cor}{The correlations of the components matched to this robust
  component; a matrix of size \eqn{length(models) \times Krobust}. The
  correlations are reported relative to the first repetition with this
  component observed.}
}
\description{
\code{robustComponents} analyzes a collection of sampling chains and returns
  robust components.
}
\details{
The function returns the effects (i.e. reconstructions) of robust components
to the data level. It is useful for a thorough model interpretation,
accumulating power over several sampling chains by
comparing them in the observation space (as opposed to the latent space).
The function is needed for this task, as the extreme multi-modality of factor
analysis prohibits efficient sampling techniques that would result in a
posterior estimate converging to the true posterior in practice.
The function uses a heuristic correlation-based procedure to analyze which
components occur frequently in GFA sampling chains.
}
\examples{
X <- matrix(rnorm(10*2),10,2)
W <- matrix(rnorm(15*2),15,2)
Y <- tcrossprod(X,W) + matrix(rnorm(10*15),10,15)
opts <- getDefaultOpts() #Default options
#Fast runs for the demo, default options recommended in general
opts[c("iter.burnin", "iter.max")] <- c(500, 1000)
res <- list()
for(i in 1:4) res[[i]] <- gfa(list(Y[,1:6],Y[,7:15]),opts=opts,K=3)
rob <- robustComponents(res)
}
