% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stftmod.R
\name{stftcalc}
\alias{stftcalc}
\title{calculate the fft components}
\usage{
stftcalc(
  X,
  win = 10,
  inc = win/2,
  coef = Inf,
  wtype = "hanning.window",
  freq,
  centre = T,
  calc.null = F,
  pvalues = F,
  time = NULL,
  reassign = T,
  quiet = F
)
}
\arguments{
\item{win}{Window size in number of recordings to use.}

\item{inc}{increment size from one window to the next}

\item{coef}{Number of fourier frequencies to compute. Small values will remove the higher frequencies from the processed object. Defaults to the maximum, win/2.}

\item{wtype}{Window type for the STFT calculation.}

\item{freq}{frequency of dataset.
If missing and length(time) > 1, freq =(length(time) -1) /( max(time) - min(time) )
If just missing, freq = 1}

\item{centre}{If TRUE (Default), centre the data in each window before processing is done.
Useful for avoiding excessively large DC offset coefficients in results.}

\item{calc.null}{If TRUE (Defaults to FALSE), compute a 'null' STFT by resampling the data completely, then doing a STFT.}

\item{pvalues}{If TRUE (Defaults to FALSE) Compute bootstrapped pvalues for each position by resampling within each window and applying a wilcox test.}

\item{time}{Allows the user to set an overriding timestamp vector to be used for processing.}

\item{reassign}{logical. If TRUE, compute the time-reassigned STFT. For type \%in\% c("mv", "sum"), this is done with the first coordinate in mv.indices.}

\item{quiet}{If TRUE, suppress output.}

\item{x}{The dataset to be processed}
}
\description{
stftcalc calculating the short time fourier transform component
}
\keyword{internal}
