% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G.R
\name{g}
\alias{g}
\title{Debiasing covariate for GECalib}
\usage{
g(x, entropy = NULL, del = NULL)
}
\arguments{
\item{x}{A vector of design weights}

\item{entropy}{An optional data frame containing the variables in the model (specified by \code{formula}).}

\item{del}{The optional vector for threshold (\eqn{\delta}) when \code{entropy == "PH"}.}
}
\value{
A vector of debiasing covariate.
}
\description{
It returns the debiasing covariate, which is equivalent to the first order derivatie of
the generalized entropy \eqn{G}.
}
\examples{
set.seed(11)
N = 10000
x = data.frame(x1 = rnorm(N, 2, 1), x2= runif(N, 0, 4))
pi = pt((-x[,1] / 2 - x[,2] / 2), 3);
pi = ifelse(pi >.7, .7, pi)

g_EL <- g(1 / pi, entropy = 1)
g_ET <- g(1 / pi, entropy = 0)
g_EL <- g(1 / pi, entropy = -1)

}
