% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCES_A.R
\name{SCES_A}
\alias{SCES_A}
\title{Standard CES Demand Coefficient Matrix}
\usage{
SCES_A(sigma, alpha, Beta, p)
}
\arguments{
\item{sigma}{a numeric m-vector or m-by-1 matrix.}

\item{alpha}{a nonnegative numeric m-vector or m-by-1 matrix.}

\item{Beta}{a nonnegative numeric n-by-m matrix.}

\item{p}{a nonnegative numeric n-vector or n-by-1 matrix.}
}
\value{
A demand coefficient n-by-m matrix.
}
\description{
This function computes the standard CES demand
coefficient matrix (i.e. Theta==Beta), which is a wrapper of CES_A of CGE package.
}
\examples{
SCES_A(-1, 1, c(0.9, 0.1), c(1, 1))
SCES_A(0, 1, c(0.9, 0.1), c(1, 1))
beta <- c(0.9, 0.1)
CD_A(prod(beta^-beta), c(0.9, 0.1), c(1, 1))

####
SCES_A(0, 1, c(0.9, 0.1, 0), c(1, 1, 1))

####
input <- matrix(c(
  200, 300, 100,
  150, 320, 530,
  250, 380, 0
), 3, 3, TRUE)
Beta <- prop.table(input, 2)
SCES_A(sigma = rep(0, 3), alpha = c(1, 1, 1), Beta = Beta, p = c(1, 1, 1))
SCES_A(sigma = rep(-Inf, 3), alpha = c(1, 1, 1), Beta = Beta, p = c(1, 1, 1))
}
