% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_score_stats.R
\name{calc_score_stats}
\alias{calc_score_stats}
\title{calc_score_stats.R}
\usage{
calc_score_stats(null_model, factor_matrix, link_function, P_mat = NULL)
}
\arguments{
\item{null_model}{An R regression model fitted using glm().  Do not use lm(), even for linear regression!}

\item{factor_matrix}{An n*p matrix with each factor as one column.  There should be no missing data.}

\item{link_function}{Either "linear" or "logit" or "log"}

\item{P_mat}{The projection matrix used in calculation may be passed in to speed up the calculation.
See paper for details. Default is null.}
}
\value{
A list with the elements:
\item{test_stats}{The p score test statistics.}
\item{cor_mat}{The p*p matrix giving the pairwise correlation of every two test statistics.}
}
\description{
Starting with individual-level data on p factors, generate score test statistics for each
factor for input into GBJ/GHC/HC/BJ/minP.  Also get the correlations between these test statistics.
Designed to be used with linear or logistic or log-linear regression null models.
}
\examples{
set.seed(0)
Y <- rbinom(n=100, size=1, prob=0.5)
null_mod <- glm(Y~1, family=binomial(link="logit"))
factor_mat <- matrix(data=rnorm(n=100*5), nrow=100)
calc_score_stats(null_mod, factor_mat, "logit")
}
