% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBJ.R
\name{GBJ}
\alias{GBJ}
\title{GBJ.R}
\usage{
GBJ(test_stats, cor_mat = NULL, pairwise_cors = NULL)
}
\arguments{
\item{test_stats}{Vector of test statistics for each factor in the set (i.e. marginal
test statistic for each SNP in a gene).}

\item{cor_mat}{d*d matrix of the correlations between all the test statistics in
the set, where d is the total number of test statistics in the set.
You only need to specify EITHER cor_mat OR pairwise_cors.}

\item{pairwise_cors}{A vector of all d(d-1)/2 pairwise correlations between the test
statistics. You only need to specify EITHER cor_mat OR pairwise_cors.}
}
\value{
A list with the elements:
\item{GBJ}{The observed Generalized Higher Criticism test statistic.}
\item{GBJ_pvalue}{The p-value of this observed value, given the size of the set and
correlation structure.}
\item{err_code}{Sometimes if your p-value is very small (<10^(-12) usually), R/C++ do not
have enough precision in their standard routines to calculate the number accurately. In
these cases (and very rarely others) we switch to standard Berk-Jones instead (more stable
numerically) and let you know with a message here.}
}
\description{
Calculate the Generalized Berk-Jones test statistic and p-value.
}
\examples{
# Should return statistic = 0.9248399 and p_value = 0.2670707
set.seed(100)
Z_vec <- rnorm(5) + rep(1,5)
cor_Z <- matrix(data=0.2, nrow=5, ncol=5)
diag(cor_Z) <- 1
GBJ(test_stats=Z_vec, cor_mat=cor_Z)
}

