% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relationship_plot.R
\name{relationship_plot}
\alias{relationship_plot}
\title{Plot relationship between data and grouping factors}
\usage{
relationship_plot(
  qtl_file,
  x,
  y,
  grid.col = "gray60",
  degree = 90,
  canvas.xlim = c(-2, 2),
  canvas.ylim = c(-2, 2),
  cex,
  gap
)
}
\arguments{
\item{qtl_file}{The output from find_genes_qtls_around_markers function}

\item{x}{The first grouping factor, to be plotted in the left hand side of the chord plot}

\item{y}{The second grouping factor, to be plotted in the left hand side of the chord plot}

\item{grid.col}{A character with the grid color for the chord plot or a vector with different colors to be used in the grid colors. Note that when a color vector is provided, the length of this vector must be equal the number of sectors in the chord plot}

\item{degree}{A numeric value corresponding to the starting degree from which the circle begins to draw. Note this degree is always reverse-clockwise}

\item{canvas.xlim}{The coordinate for the canvas in the x-axis. By default is c(-1,1)}

\item{canvas.ylim}{The coordinate for the canvas in the y-axis. By default is c(-1,1)}

\item{cex}{The size of the labels to be printed in the plot}

\item{gap}{A numeric value corresponding to the gap between the chord sectors}
}
\value{
A chords relating x and y
}
\description{
Takes the output from find_genes_qtls_around_markers function and creates a chord plot with the relationship between groups
}
\examples{
\donttest{data(QTLmarkers)
data(gffQTLs)
out.qtls<-find_genes_qtls_around_markers(
db_file=gffQTLs, marker_file=QTLmarkers,
method = "qtl", marker = "snp",
interval = 500000, nThreads = 1)

out.enrich<-qtl_enrich(qtl_db=gffQTLs,
qtl_file=out.qtls, qtl_type = "Name",
enrich_type = "chromosome",
chr.subset = NULL, padj = "fdr",nThreads = 1)

out.enrich$ID<-paste(out.enrich$QTL," - ",
"CHR",out.enrich$CHR,sep="")

out.enrich.filtered<-out.enrich[which(out.enrich$adj.pval<0.05),]

out.qtls$ID<-paste(out.qtls$Name," - ",
"CHR",out.qtls$CHR,sep="")

out.enrich.filtered<-out.enrich.filtered[order(out.enrich.filtered$adj.pval),]

out.qtls.filtered<-out.qtls[which(out.qtls$ID\%in\%out.enrich.filtered$ID[1:10]),]

out.qtls.filtered[which(out.qtls.filtered$Reference==
"Feugang et al. (2010)"), "color_ref"]<-"purple"

out.qtls.filtered[which(out.qtls.filtered$Reference==
"Buzanskas et al. (2017)"),"color_ref"]<-"pink"

color.grid<-c(rep("black",length(unique(out.qtls.filtered$Abbrev))),
unique(out.qtls.filtered$color_ref))

names(color.grid)<-c(unique(out.qtls.filtered$Abbrev),
unique(out.qtls.filtered$Reference))

relationship_plot(qtl_file=out.qtls.filtered,
x="Abbrev", y="Reference",cex=1,gap=5,
degree = 90, canvas.xlim = c(-5, 5),
canvas.ylim = c(-3, 3), grid.col = color.grid)}
}
