% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.GAGA.R
\name{predict.GAGA}
\alias{predict.GAGA}
\title{Get predictions from a GAGA fit object}
\usage{
\method{predict}{GAGA}(object, newx, ...)
}
\arguments{
\item{object}{Fitted "GAGA" object.}

\item{newx}{Matrix of new values for x at which predictions are to be made. Must be a
matrix.  If the intercept term needs to be considered in the estimation process, then
the first column of \code{X} must be all 1s.}

\item{...}{some other params}
}
\value{
Predictions
}
\description{
Gives fitted values from a fitted GAGA object.
}
\examples{
set.seed(2022)
p_size = 30
sample_size=300
R1 = 3
R2 = 2
rate = 0.5 #Proportion of value zero in beta
# Set true beta
zeroNum = round(rate*p_size)
ind = sample(1:p_size,zeroNum)
beta_true = runif(p_size,0,R2)
beta_true[ind] = 0
X = R1*matrix(rnorm(sample_size * p_size), ncol = p_size)
y=X\%*\%beta_true + rnorm(sample_size,mean=0,sd=2)
# Estimation
fit = GAGAs(X,y,alpha = 3,family="gaussian")
Eb = fit$beta
#Create testing data
X_t = R1*matrix(rnorm(sample_size * p_size), ncol = p_size)
y_t=X_t\%*\%beta_true + rnorm(sample_size,mean=0,sd=2)
#Prediction
Ey = predict.GAGA(fit,newx=X_t)

cat("\n err:", norm(Eb-beta_true,type="2")/norm(beta_true,type="2"))
cat("\n acc:", cal.w.acc(as.character(Eb!=0),as.character(beta_true!=0)))
cat("\n perr:", norm(Ey-y_t,type="2")/sqrt(sample_size))

}
