# **FuzzyStatTraEOO**

## Package 'FuzzyStatTra' in Encapsulated Object Oriented Programming

[![CRAN status](https://www.r-pkg.org/badges/version/FuzzyStatTraEOO)](https://CRAN.R-project.org/package=FuzzyStatTraEOO) [![Total downloads](https://cranlogs.r-pkg.org/badges/grand-total/FuzzyStatTraEOO)](https://CRAN.R-project.org/package=FuzzyStatTraEOO)

### Description

**FuzzyStatTraEOO** is an open source package for the **R** environment that contains the package 'FuzzyStatTra' in Encapsulated Object Oriented Programming. 'FuzzyStatTra' contains Statistical Methods for Trapezoidal Fuzzy Numbers, whose aim is to provide some basic functions for doing statistical analysis with trapezoidal fuzzy numbers.

Trapezoidal fuzzy numbers are widely used in fuzzy scale rates in Social, Educational Sciences and many other disciplines as a strong alternative to both traditional Likert-type or visual analogue scales in some questionnaires measuring people's behavior (attitudes, opinions, perceptions, feelings, etc.). This type of data can not be directly measured because it concerns inherently imprecise features. Likert-type and visual analogue scales force respondents to choose single-point answers linked to some items (statements or questions), so individual differences are almost systematically overlooked.

Now, those functions are organized in specific encapsulated classes and methods with reference semantincs using the published R package **R6**. This object-based approach is an important step in making statistical computing more accessible to users.

Finally, it should also be remarked that the **FuzzyStatTraEOO** package includes some real-life data sets.

### Authors

Andrea García Cernuda and María Asunción Lubiano Gómez, with contributions from Sara de la Rosa de Saá.

### Installation

To install the **FuzzyStatTraEOO** package in **R** environment please use:

``` r
# Install from CRAN
install.packages("FuzzyStatTraEOO",dependencies = TRUE)
```

### Citation

To cite the **FuzzyStatTraEOO** package in publications please use:

> **[Garciaetal22]** García Cernuda, A. "FuzzyStatTraEOO: Package 'FuzzyStatTra' in Encapsulated Object Oriented Programming". R package version 0.1.0. 2022. <https://cran.r-project.org/package=FuzzyStatTraEOO>.

### See also

For more details, you can visit the website of the SMIRE+CoDiRE (Statistical Methods with Imprecise Random Elements and Comparison of Distributions of Random Elements) Research Group (<https://bellman.ciencias.uniovi.es/smire+codire/>) from the University of Oviedo (Spain). The most related paper can be found in References.
