% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyInferenceSystem.R
\name{plotmf}
\alias{plotmf}
\title{Plots a 2D graph of all membership functions in a variable.}
\usage{
plotmf(fis, varType, varIndex, xx = NULL, timelimit = 0, xlab = NULL,
  ylab = NULL, main = NULL)
}
\arguments{
\item{fis}{Requires an existing fis as an argument.}

\item{varType}{Can be either 'input' or 'output', representing the type of variable.}

\item{varIndex}{A numerical integer, representing the index of the input or output variable whose membership functions shall be plotted (base 1).}

\item{xx}{primary inputs for extra lines}

\item{timelimit}{for perturbation}

\item{xlab}{X axis label using font, size and color}

\item{ylab}{Y axis label, same font attributes as xlab}

\item{main}{The main title (on top)}
}
\value{
A two dimensional graph displaying all the membership functions of a given variable.
}
\description{
Plots a 2D graph of all membership functions from the specified variable which must be part of a fis object.
}
\examples{
fis <- tipper()
plotmf(fis, "input", 1)
}

