% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-integrate.R
\docType{methods}
\name{integrateAlpha}
\alias{integrateAlpha}
\alias{integrateAlpha,FuzzyNumber,character,numeric,numeric-method}
\alias{integrateAlpha,DiscontinuousFuzzyNumber,character,numeric,numeric-method}
\title{Numerically Integrate Alpha-Cut Bounds}
\usage{
\S4method{integrateAlpha}{FuzzyNumber,character,numeric,numeric}(object, which=c("lower", "upper"),
   from=0, to=1, weight=NULL, transform=NULL, ...)

\S4method{integrateAlpha}{DiscontinuousFuzzyNumber,character,numeric,numeric}(object, which=c("lower", "upper"),
   from=0, to=1, weight=NULL, transform=NULL, ...)
}
\arguments{
\item{object}{a fuzzy number}

\item{which}{one of \code{"lower"}, \code{"upper"}}

\item{from}{numeric}

\item{to}{numeric}

\item{...}{additional arguments passed to \code{\link{integrate}} or \code{\link{integrate_discont_val}}}

\item{weight}{a function or NULL}

\item{transform}{a function or NULL}
}
\value{
Returns a single numeric value.
}
\description{
Integrates numerically a transformed or weighted lower or upper alpha-cut bound of a fuzzy number.
}
\seealso{
Other FuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{FuzzyNumber-class}},
  \code{\link{FuzzyNumber}}, \code{\link{alphaInterval}},
  \code{\link{alphacut}}, \code{\link{ambiguity}},
  \code{\link{as.FuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}}, \code{\link{core}},
  \code{\link{distance}}, \code{\link{evaluate}},
  \code{\link{expectedInterval}},
  \code{\link{expectedValue}},
  \code{\link{piecewiseLinearApproximation}},
  \code{\link{plot}}, \code{\link{show}},
  \code{\link{supp}},
  \code{\link{trapezoidalApproximation}},
  \code{\link{value}}, \code{\link{weightedExpectedValue}},
  \code{\link{width}}

Other DiscontinuousFuzzyNumber-method: \code{\link{DiscontinuousFuzzyNumber-class}},
  \code{\link{DiscontinuousFuzzyNumber}},
  \code{\link{distance}}, \code{\link{plot}}
}
\concept{DiscontinuousFuzzyNumber-method}
\concept{FuzzyNumber-method}
