\name{pb}
\alias{pb}
\alias{pb.list}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Function to generate non-regular fractional factorial screening designs }
\description{
  The function generates Plackett-Burman designs and in some cases other screening 
  designs in run numbers that are a multiple of 4. These designs are particularly suitable for screening a 
  large number of factors, since interactions are not fully aliased with one main effect each 
  but partially aliased. (The designs in 8 and 64 runs are exceptions from this rule.)
}
\usage{
pb(nruns, nfactors = nruns - 1, factor.names = if (nfactors <= 50) 
     Letters[1:nfactors] else paste("F", 1:nfactors, sep = ""), 
     default.levels = c(-1, 1), boxtyssedal = TRUE, n12.taguchi = FALSE, 
     replications = 1, repeat.only = FALSE, 
     randomize = TRUE, seed = NULL, ...)

pb.list
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{nruns}{ number of runs, must be a multiple of 4 }
  \item{nfactors}{ number of factors, default is nruns - 1, and it is recommended to retain this default. 
   It is possible to specify factor names for fewer factors, and the remaining columns will be named \code{e1}, \code{e2}, ... 
   They are useful for representing error in effects plots. }
  \item{factor.names}{ a character vector of factor names (length up to nfactors) or a named list with names representing factor names and elements vectors of length 2 with factor levels for each factor. Elements can be empty strings. In this case, default levels are used for the respective factor. }
  \item{default.levels}{ default levels (vector of length 2) for all factors for which no specific levels are given }
  \item{boxtyssedal}{ logical, relevant only for nruns=16. 
               If FALSE, the geometric (=standard) 16 run plan is used. 
               If TRUE, the proposal by Box and Tyssedal is used instead, which has the advantage (for screening) of aliasing each interaction with several main effects, like the other Plackett-Burman designs. }
  \item{n12.taguchi}{ logical, relevant only for nruns=12. If TRUE, the 12 run design is given in Taguchi order. }
  \item{replications}{ positive integer number. Default 1 (i.e. each row just once). 
       If larger, each design run is executed replication times. 
       If \code{repeat.only}, repeated measurements 
       are carried out directly in sequence, i.e. no true replication takes place, 
       and all the repeat runs are conducted together. It is likely that the error 
       variation generated by such a procedure will be too small, so that average values 
       should be analyzed for an unreplicated design. 
       
       Otherwise (default), the full experiment is first carried out once, then 
       for the second replication and so forth. In case of randomization, 
       each such blocks is randomized separately. In this case, replication variance is 
       more likely suitable for usage as error variance 
       (unless e.g. the same parts are used for replication runs although build 
       variation is important). }
  \item{repeat.only}{ logical, relevant only if replications > 1. If TRUE, 
        replications of each run are grouped together 
       (repeated measurement rather than true replication). The default is 
       \code{repeat.only=FALSE}, i.e. the complete experiment 
       is conducted in \code{replications} blocks, and each run occurs in each block. }
  \item{randomize}{ logical. If TRUE, the design is randomized. This is the default. }
  \item{seed}{ optional seed for the randomization process }
  \item{\dots}{ currently not used }
}
\details{
  \code{pb} stands for Plackett-Burman. Plackett-Burman designs (Plackett and Burman 1946) are generally 
  used for screening many variables in relatively few runs, when interest is in 
  main effects only, at least initially. Different from the regular 
  fractional factorial designs created by function \code{\link{FrF2}}, they 
  do not perfectly confound interaction terms with main effects but distribute 
  interaction effects over several main effects. The designs with number of runs 
  a power of 2 are an exception to this rule: they are just the resolution III 
  regular fractional factorial designs and are as such not very suitable for 
  screening because of a high risk of very biased estimates for the main effects 
  of the factors. Where possible, these are therefore replaced by different designs (cf. below).
  
  For most run numbers, function \code{pb} uses Plackett-Burman designs, 
  and simply fills columns from left to right. 
  The generating rows for these designs can be found in the list \code{pb.list} 
  (a 0 entry indicates that the design is constructed by a different method, e.g. doubling).
  
  For 12 runs, the isomorphic design by Taguchi can be requested. 
  For 16 runs, the default is to use the designs suggested by Box and Tyssedal (2001), 
  which up to 14 factors do not suffer from perfect aliasing. 
  For 32 runs, a cyclic design with generating row given in Samset and Tyssedal (1999) is used. 
  For 64 runs, the 32 run design is doubled.
  For 92 runs, a design is constructed according to the Williamson construction with matrices A, B, C and D from Hedayat and Stufken (1999), p. 160. 
  
  So far, designs up to 96~runs are covered. More and different ones may follow, since the package is currently under intensive development.
  
  Usage of the 8~run design for more than 4~factors is discouraged, 
  as it completely aliases main effects with individual two-factor interactions. 
  It is recommended to use the 12~run design instead for screening more than 4~factors. 
}
\value{
  Value is a data frame of S3 class \code{design} with attributes attached. 
  The data frame itself contains the design with levels coded as requested.
  The following attributes are attached to it:
  \item{desnum }{Design matrix in -1/1 coding}
  \item{run.order }{three column data frame, first column contains the run number in 
       standard order, second column the run number as randomized, third column the 
       run number with replication number as postfix;
       useful for switching back and forth between actual and standard run 
       number}
  \item{design.info }{list with entries   
  \itemize{
        \item{type }{ character string \dQuote{pb}, except for 8~runs with up to 
           4~factors, for which a type \dQuote{FrF2} design is output}
        \item{nruns }{ number of runs (replications are not counted) }
        \item{nfactors }{ number of factors; not for designs of type \code{FrF2.blocked}, 
           where \code{ntreat} takes this role}
        \item{ntreat }{ for designs of type \code{FrF2.blocked} only; \cr
           number of treatment factors }
        \item{factor.names }{ list named with (treatment) factor names and containing as 
           entries vectors of length two each with coded factor levels }
       \item{replication }{ option setting in call to \code{pb} }
       \item{repeat.only }{ option setting in call to \code{pb} }
       \item{randomize }{ option setting in call to \code{pb} }
       \item{seed }{ option setting in call to \code{pb} }
       \item{creator }{ call to function pb 
          (or stored menu settings, if the function has been called via the R commander plugin 
          \pkg{RcmdrPlugin.DoE}) }
       }
       }
}
\references{ 
  Box, G.E.P. and Tyssedal, J. (2001) Sixteen Run Designs of High Projectivity for Factor Screening. 
      \emph{Communications in Statistics - Simulation and Computation} \bold{30}, 217-228. 
      
  Hedayat, A.S., Sloane, N.J.A. and Stufken, J. (1999) \emph{Orthogonal Arrays: Theory and Applications}, Springer, New York. 
  
  Plackett, R.L.; Burman, J.P. (1946) The design of optimum multifactorial experiments. \emph{Biometrika} \bold{33}, 305-325.
  
  Samset, O.; Tyssedal, J. (1999) Two-level designs with good projection properties. \emph{Technical Report 12, 
  Department of Mathematical Sciences, The Norwegian University of Science and Technology, Norway}.  
  
  Williamson, J. (1946) Determinants whose elements are 0 and 1. \emph{American Mathematical Monthly} \bold{53}, 427-434.
}
\author{ Ulrike Groemping }

\seealso{ See Also \code{\link{FrF2}} for regular fractional factorial designs }
\examples{
   pb(12,randomize=FALSE)
   pb(12,randomize=FALSE,n12.taguchi=TRUE)
   pb(20,seed=29869)
   pb(16,factor.names=list(A="",B="",C="",D=c("min","max"),
          E="",F="",G="",H="",J=c("new","old")))
   pb(8,default.levels=c("current","new"))
   test <- pb(40) ## design created by doubling the 20 run design
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ array }
\keyword{ design }% __ONLY ONE__ keyword per line
