% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.tip.sampling.R
\name{sim.tip.samples}
\alias{sim.tip.samples}
\title{Include extant and extinct tip samples in the fossil object, with optional rho sampling.}
\usage{
sim.tip.samples(fossils, tree, taxonomy = NULL, rho = 1)
}
\arguments{
\item{fossils}{Fossils object.}

\item{tree}{Phylo object.}

\item{taxonomy}{Taxonomy object.}

\item{rho}{Tip sampling probability.}
}
\value{
An object of class fossils containing extant or extinct tip samples equal to the age of the tips.
}
\description{
Include extant and extinct tip samples in the fossil object, with optional rho sampling.
}
\examples{
# simulate tree
t = ape::rtree(6)

# simulate fossils
f = sim.fossils.poisson(2, t)

# simulate tip samples
f = sim.tip.samples(f, t, rho = 0.5)
plot(f, t)

}
