% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EW_Fi_MLM_func.R
\name{EW_Fi_MLM_func}
\alias{EW_Fi_MLM_func}
\title{function to generate the expected fisher information at one design point xi for multinomial logit models}
\usage{
EW_Fi_MLM_func(X_x, bvec_matrix, link = "continuation")
}
\arguments{
\item{X_x}{model matrix for a specific design point x_i, X_x=h.func(xi)}

\item{bvec_matrix}{the matrix of the sampled parameter values of beta}

\item{link}{multinomial logit model link function name "baseline", "cumulative", "adjacent", or"continuation", default to be "continuation"}
}
\value{
F_x     The expected Fisher information matrix at x_i

EU_x    E(U) matrix for calculation the expected of Fisher information matrix at x_i
}
\description{
function to generate the expected fisher information at one design point xi for multinomial logit models
}
\examples{
link.temp = "continuation"
xi.temp=c(80)
hfunc.temp = function(y){
matrix(data=c(1,y,y*y,0,0,0,0,0,1,y,0,0,0,0,0), nrow=3, ncol=5, byrow=TRUE)
}
X_xtemp=hfunc.temp(xi.temp)
bvec_bootstrap<-matrix(c(-0.2401, -1.9292, -2.7851, -1.614,-1.162,
                         -0.0535, -0.0274, -0.0096,-0.0291, -0.04,
                          0.0004,  0.0003,  0.0002,  0.0003,  0.1,
                         -9.2154, -9.7576, -9.6818, -8.5139, -8.56),nrow=4,byrow=TRUE)
EW_Fi_MLM_func(X_x=X_xtemp, bvec_matrix=bvec_bootstrap, link=link.temp)
}
