% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bottomup.R
\name{csbu}
\alias{csbu}
\title{Cross-sectional bottom-up reconciliation}
\usage{
csbu(base, agg_mat, sntz = FALSE)
}
\arguments{
\item{base}{A (\eqn{h \times n_b}) numeric matrix or multivariate time series
(\code{mts} class) containing bottom base forecasts; \eqn{h} is the
forecast horizon, and \eqn{n_b} is the total number of bottom variables.}

\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{sntz}{If \code{TRUE}, the negative base forecasts are
set to zero before applying bottom-up.}
}
\value{
A (\eqn{h \times n}) numeric matrix of cross-sectional reconciled forecasts.
}
\description{
This function computes the cross-sectional bottom-up reconciled forecasts
(Dunn et al., 1976) for all series by appropriate summation of the bottom
base forecasts \eqn{\widehat{\mathbf{b}}}:
\deqn{\widetilde{\mathbf{y}} = \mathbf{S}_{cs}\widehat{\mathbf{b}},}
where \eqn{\mathbf{S}_{cs}} is the cross-sectional structural matrix.
}
\examples{
set.seed(123)
# (3 x 2) bottom base forecasts matrix (simulated), Z = X + Y
bts <- matrix(rnorm(6, mean = c(10, 10)), 3, byrow = TRUE)

# Aggregation matrix for Z = X + Y
A <- t(c(1,1))
reco <- csbu(base = bts, agg_mat = A)

# Non negative reconciliation
bts[2,2] <- -bts[2,2] # Making negative one of the base forecasts for variable Y
nnreco <- csbu(base = bts, agg_mat = A, sntz = TRUE)

}
\references{
Dunn, D. M., Williams, W. H. and Dechaine, T. L. (1976), Aggregate versus subaggregate
models in local area forecasting, \emph{Journal of the American Statistical Association}
71(353), 68–71. \doi{10.1080/01621459.1976.10481478}
}
\seealso{
Bottom-up reconciliation: 
\code{\link{ctbu}()},
\code{\link{tebu}()}

Cross-sectional framework: 
\code{\link{csboot}()},
\code{\link{cscov}()},
\code{\link{cslcc}()},
\code{\link{csmo}()},
\code{\link{csrec}()},
\code{\link{cstd}()},
\code{\link{cstools}()}
}
\concept{Framework: cross-sectional}
\concept{Reco: bottom-up}
