% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_ts.R
\name{agg_ts}
\alias{agg_ts}
\title{Non-overlapping temporal aggregation of a time series}
\usage{
agg_ts(agg_order, x, align = "end", rm_na = FALSE)
}
\arguments{
\item{agg_order}{Aggregation order to consider.}

\item{x}{Univariate time series: a vector or a \code{ts} object.}

\item{align}{Specifies whether the aggregates should be aligned with the start ()
or end of the series.}

\item{rm_na}{logical. Should missing values be removed?}
}
\value{
A vector or \code{ts} object
}
\description{
Non-overlapping temporal aggregation of a time series according
to a specific aggregation order.
}
\examples{
data(FoReco_data)
annual_ts <- agg_ts(12, FoReco_data$obs$k1[,1]) # == FoReco_data$obs$k12[,1]

}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{arrange_hres}()},
\code{\link{commat}()},
\code{\link{ctf_tools}()},
\code{\link{hts_tools}()},
\code{\link{lcmat}()},
\code{\link{oct_bounds}()},
\code{\link{residuals_matrix}()},
\code{\link{score_index}()},
\code{\link{shrink_estim}()},
\code{\link{thf_tools}()}
}
\concept{utilities}
