% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ut2c.R
\name{ut2c}
\alias{ut2c}
\title{Cross-sectional 'structural representation' of a general linearly constrained
multiple time series}
\usage{
ut2c(Ut, sparse = TRUE, verbose = FALSE)
}
\arguments{
\item{Ut}{(\mjseqn{r \times c}) zero constraints cross-sectional
(contemporaneous) kernel matrix \mjseqn{(\mathbf{U}'\mathbf{y} = \mathbf{0})}
spanning the null space valid for the target forecasts.}

\item{sparse}{Option to return sparse object (\emph{default} is \code{TRUE}).}

\item{verbose}{If \code{TRUE}, print intermediate steps of \code{\link{srref}}.}
}
\value{
A list with
\item{\code{Ut_reshape}}{matrix with rows and columns rearranged so that
each row has 1 as the first non-null element starting from the left,
and that the first r columns have 1 as the first element starting from
the bottom, \mjseqn{\mathbf{U}_{reshape}' = \mathbf{U}'[,\mbox{cid}]}.}
\item{\code{Ut_rref}}{reduced row echelon form of \mjseqn{\mathbf{U}'_{reshape}} with
\link{srref}.}
\item{\code{C}}{(\mjseqn{n_a \times n_b}) cross-sectional (contemporaneous) matrix
mapping the bottom level series into the higher level ones,
\mjseqn{\mathbf{U}_{srref}' = [\mathbf{I} \ -\mathbf{C}]}.}
\item{\code{cid}}{(\mjseqn{c \times 1}) vector of the column permutations of the matrix \mjseqn{\mathbf{U}'}.}
\item{\code{nb}}{number of bottom time series, \mjseqn{n_b}.}
\item{\code{na}}{number of upper time series, \mjseqn{n_a = r}.}
\item{\code{n}}{number of time series, \mjseqn{n_a + n_b = n = c}.}
}
\description{
\loadmathjax
Switching from a zero-constraints kernel representation of a linearly constrained
multiple time series, \mjseqn{\mathbf{U}'\mathbf{y}=\mathbf{0}},
to a 'structural representation', \mjseqn{\mathbf{y}=\mathbf{S}\mathbf{b}}.
(\emph{Experimental version})
}
\details{
Consider the simple example of linearly constrained multiple time series consisting
of two hierarchies, each with distinct bottom time series,
with a common top-level series (\mjseqn{T}):
\mjsdeqn{\begin{array}{ll}
1)\; T = A + B        & 4)\; T = X + Y \cr
2)\; A = AA + AB      & 5)\; X = XX + XY \cr
3)\; B = BA + BB + BC & 6)\; Y = YX + YY
\end{array}.}
Given the cross-sectional aggregation matrices of each hierarchy,
\mjsdeqn{\mathbf{C}_1 = \left[\begin{array}{ccccc}
1 & 1 & 0 & 0 & 0\cr
0 & 0 & 1 & 1 & 1
\end{array}\right]\quad \mathrm{and} \quad \mathbf{C}_2 = \left[\begin{array}{ccccc}
1 & 1 & 0 & 0\cr
0 & 0 & 1 & 1
\end{array}\right],}
the zero constraints cross-sectional kernel matrix \mjseqn{\mathbf{U}'},
which accounts for the constraints of both hierarchies,
can be built as follows:
\mjsdeqn{\mathbf{U}' = \left[\begin{array}{cccccccccccccc|c}
1 & 0 & 0 &-1 &-1 &-1 &-1 &-1 & 0 & 0 & 0 & 0 & 0 & 0 & T\cr
1 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 &-1 &-1 &-1 &-1 & T\cr
0 & 1 & 0 &-1 &-1 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & A\cr
0 & 0 & 1 & 0 & 0 &-1 &-1 &-1 & 0 & 0 & 0 & 0 & 0 & 0 & B\cr
0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 1 & 0 &-1 &-1 & 0 & 0 & X\cr
0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 1 & 0 & 0 &-1 &-1 & Y\cr
\hline
T & A & B & AA& AB& BA& BB& BC& X & Y & XX& XY& YX& YY&
\end{array}\right].}
Function \code{\link{ut2c}} returns a matrix
\mjseqn{\mathbf{U}'_{rref} = \left[\mathbf{I}_6 \; -\mathbf{C} \right]}:
\mjsdeqn{\mathbf{U}'_{rref} = \left[\begin{array}{cccccccccccccc|c}
1 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 & 0 &-1 &-1 &-1 &-1 & T\cr
0 & 1 & 0 & 0 & 0 & 0 & 0 & 1 & 1 & 1 &-1 &-1 &-1 &-1 & A\cr
0 & 0 & 1 & 0 & 0 & 0 & 0 &-1 &-1 &-1 & 0 & 0 & 0 & 0 & B\cr
0 & 0 & 0 & 1 & 0 & 0 & 0 & 0 & 0 & 0 &-1 &-1 & 0 & 0 & X\cr
0 & 0 & 0 & 0 & 1 & 0 & 0 & 0 & 0 & 0 & 0 & 0 &-1 &-1 & Y\cr
0 & 0 & 0 & 0 & 0 & 1 & 1 & 1 & 1 & 1 &-1 &-1 &-1 &-1 & AA\cr
\hline
T & A & B & X & Y & AA& AB& BA& BB& BC& XX& XY& YX& YY&
\end{array}\right],}
from which the 'structural sum matrix'
\mjsdeqn{\mathbf{S} = \left[\mathbf{C}' \; \mathbf{I}_8 \right]'}
may be easily obtained.
}
\examples{
C1 <- Matrix(c(1,1,0,0,0,
               0,0,1,1,1), 2, byrow = TRUE, sparse = TRUE)
C2 <- Matrix(c(1,1,0,0,
               0,0,1,1), 2, byrow = TRUE, sparse = TRUE)
Ut <- rbind(c(1, rep(0, NROW(C1)), rep(-1, NCOL(C1)), rep(0, NROW(C2)), rep(0, NCOL(C2))),
            c(1, rep(0, NROW(C1)), rep(0, NCOL(C1)), rep(0, NROW(C2)), rep(-1, NCOL(C2))),
            cbind(0, Diagonal(NROW(C1)), -C1, Matrix(0, NROW(C1), NROW(C2)+NCOL(C2))),
            cbind(0, Matrix(0, NROW(C2), NROW(C1)+NCOL(C1)), Diagonal(NROW(C2)), -C2))
colnames(Ut) <- c("T", "A", "B", "AA", "AB", "BA", "BB", "BC",
                  "X", "Y", "XX", "XY", "YX", "YY")
rownames(Ut) <- c("T", "T", "A", "B", "X", "Y")
obj_ut2c <- ut2c(Ut, sparse = FALSE)
Ut_struc <- obj_ut2c$Ut_rref
S <- rbind(obj_ut2c$C, diag(1, obj_ut2c$nb))

}
\references{
Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.
}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{commat}()},
\code{\link{ctf_tools}()},
\code{\link{hts_tools}()},
\code{\link{oct_bounds}()},
\code{\link{score_index}()},
\code{\link{shrink_estim}()},
\code{\link{srref}()},
\code{\link{thf_tools}()}
}
\concept{utilities}
