% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr.events.R
\name{dr.events}
\alias{dr.events}
\title{Partial Duration Series and Event Statistics for streamflow droughts}
\usage{
dr.events(TS, Qdr = 0.2, WinSize = 30, IntEventDur = 10, EventDur = 15)
}
\arguments{
\item{TS}{data.frame of streamflow time series loaded with \code{\link{read.flows}}.}

\item{Qdr}{Numeric value of the drought threshold quantile.  Default is 0.2.}

\item{WinSize}{Numeric value specifying the size of the moving window in
days.  Default is 30.}

\item{IntEventDur}{Numeric value for the minimum inter-event duration in days. Drought
events with less than the specified number of days between will be pooled 
and considered as one event.}

\item{EventDur}{Numeric value for the minimum drought duration in days. Default
is 15.}
}
\value{
Returns a list with the following elements:

  DroughtEvents: A data.frame with the following columns:
  \itemize{
    \item Event - Integer indicating the original event number assigned before
      minor drought events were removed.
    \item Start - Date of the start of the drought event.
    \item End - Date of the end of the drought event
    \item maxDef - Numeric value of the maximum streamflow deficit.
    \item Severity - Numeric value indicating the drought severity, 
      calculated as the cumulative daily streamflow deficit in m3/s.
    \item Duration - Numeric value of the drought duration in days.
    \item Magnitude - Numeric value indicating the drought magnitude, which 
      is calculated as the mean daily streamflow deficit in m3/s.
    \item stdtotDef - Numeric value indicating the standardized cumulative
      streamflow deficit, calculated as the drought severity divided by
      the mean annual daily streamflow.
  }
  
  DroughtPDS: A data.frame of the original input TS that has been subset to 
  include only the days on which the streamflow was below the drought threshold.
  The data.frame also has the following columns appended:
  \itemize{
    \item Thresh - Numeric value indicating the streamflow drought threshold,
      as calculated by \code{\link{mqt}}
    \item BelowThresh - Logical indicating whether the observed streamflow 
      was below the streamflow drought threshold.
    \item Def - Numeric value of the streamflow defict, calculated as the 
      streamflow drought threshold (m3/s) minus the observed streamflow (m3/s).
  }
}
\description{
This function extracts the partial duration series for all streamflow droughts based
on a moving window quantile threshold.  Also returns summary information (start date,
end date, duration, deficit volume) for each drought event.
}
\examples{
data(cania.sub.ts)
res1 <- dr.events(cania.sub.ts)
events <- res1$DroughtEvents

opar <- graphics::par(no.readonly = TRUE)
par(mar=c(5,6,2,2))
plot(events$Start, events$Duration, pch=19, ylab="Drought Duration (days)", xlab="")
graphics::par(opar)
}
\seealso{
See \code{\link{dr.seas}} to calculate metrics for droughts 
  occurring in a user-defined season.
  
  This function calls \code{\link{dr.pds}} which calls \code{\link{mqt}}.
}
\author{
Jennifer Dierauer
}
