% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAMn.R
\name{MAMn}
\alias{MAMn}
\title{Calculate mean annual minimum n-day flows}
\usage{
MAMn(TS, n = 7, by = "hyear")
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{n}{Numeric value for the number of days in the n-day flow period. Default is 7.}

\item{by}{Character string indicating whether to use hydrologic years or 
calendar years.  Default is "hyear".  Other option is "year".}
}
\value{
Returns a numeric vector containing the calculated MAM n-day flow for each 
  year in the input time series.  The "times" attribute provides the corresponding
  year for each calculated value.
}
\description{
This function calculates the calculates the mean annual minimum n-day flow by
calendar year or by hydrologic year.  This function can also be used to find
the annual minimum series by setting n=1.
}
\examples{
data(cania.sub.ts)

# find the annual minimum series and plot 
res <- MAMn(cania.sub.ts, n=1)
res2 <- screen.metric(res, "Q (m3/s)")

# do the same with MAM 7-day flow instead of annual minimum
res <- MAMn(cania.sub.ts, n=7)
res2 <- screen.metric(res, "Q (m3/s)")
}
\seealso{
\code{\link{screen.metric}}
}
\author{
Jennifer Dierauer
}
