% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_eckhardt.r
\name{bf_eckhardt}
\alias{bf_eckhardt}
\title{Eckhardt two parameter recursive digital filter}
\usage{
bf_eckhardt(discharge, a, BFI)
}
\arguments{
\item{discharge}{vector of daily discharge observations}

\item{a}{Numeric value.}

\item{BFI}{Numeric value.}
}
\value{
Returns
}
\description{
This function takes vector of discharge data and estimates the baseflow
}
\examples{
data(cania.sub.ts)
bf <- bf_eckhardt(cania.sub.ts$Flow, 0.97, 0.8)
plot(cania.sub.ts$Date, cania.sub.ts$Flow, type="l")
points(cania.sub.ts$Date, bf, type="l", col="blue")
}
\author{
Paul Whitfield
}
\references{
Eckhardt, K. 2012. Technical note: Analytical sensitivity analysis 
  of two parameter recursive digital baseflow separation filter. Hydrology and
  Earth System Sciences 16: 451-455.
}

