% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Figures.R
\name{ConvergenceFig}
\alias{ConvergenceFig}
\title{A function for plotting the convergence change over a series of iterates.}
\usage{
ConvergenceFig(
  Inputs,
  Outputs,
  Input_Convergence = c(),
  LinesToDraw = c("Sup_Norm", "Euclidean_Norm", "Sum_Of_Absolute_Value_Of_Residuals",
    "Smallest_Residual"),
  LogScale = TRUE,
  FromIterate = 1,
  ToIterate = c()
)
}
\arguments{
\item{Inputs}{The Inputs matrix returned by FixedPoint.}

\item{Outputs}{The Outputs matrix returned by FixedPoint.}

\item{Input_Convergence}{Convergence vector to be used in the figure. Often makes sense for it to be the same as that used in
the Fixedpoint function.}

\item{LinesToDraw}{A vector describing which convergence metrics to draw. This vector can contain anything in c("Sup_Norm", "Euclidean_Norm",
"Sum_Of_Absolute_Value_Of_Residuals", "Smallest_Residual", "Input_Convergence"). Here "Input_Convergence" draws the input convergence vector.
"Sup_Norm" gives the greatest residual (in absolute value), "Euclidean_Norm" is the eucleadean norm of the residuals, "Sum_Of_Absolute_Value_Of_Residuals"
sums up the absolute value of the residuals and "Smallest_Residual" is the smallest residual by absolute value. Clearly if the function takes
and returns a scalar (rather than a vector) then all of these are identical.}

\item{LogScale}{This is whether or not to use a log scale. If so instead of convergence, log(1+convergence) is shown on the y axis. By default this is true.}

\item{FromIterate}{This describes the first iterate on the figure.}

\item{ToIterate}{This describes the last iterate on the figure.}
}
\value{
This function returns nothing. It just shows a plot in the console.
}
\description{
On the x axis is the index of each iterate. On the y axis are different convergence metric values.
}
\examples{
Inputs = seq(1,10)
Function = function(x){ cos(x) }
A = FixedPoint(Function, Inputs, Method = "Anderson")
ConvergenceFig(A$Inputs, A$Outputs)
# And now to only show a median norm:
Differences = A$Inputs - A$Outputs
Convergence = apply(Differences,2,function(x){median(abs(x))})
ConvergenceFig(A$Inputs, A$Outputs, Convergence, LinesToDraw = "Input_Convergence")
}
