% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_alpha_lattice.R
\name{alpha_lattice}
\alias{alpha_lattice}
\title{Generates an Alpha Design}
\usage{
alpha_lattice(
  t = NULL,
  k = NULL,
  r = NULL,
  l = 1,
  plotNumber = 101,
  locationNames = NULL,
  seed = NULL,
  data = NULL
)
}
\arguments{
\item{t}{Number of  treatments.}

\item{k}{Size of incomplete blocks (number of units per incomplete block).}

\item{r}{Number of full blocks (or resolvable replicates) (also number of replicates per treatment).}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{locationNames}{(optional) String with names for each of the \code{l} locations.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{data}{(optional) Data frame with label list of treatments.}
}
\value{
A list with two elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{fieldBook} is a data frame with the alpha design field book.
}
}
\description{
Randomly generates an alpha design like \code{alpha(0,1)} across multiple locations.
}
\examples{
# Example 1: Generates an alpha design with 4 full blocks and 15 treatments.
# Size of IBlocks k = 3.
alphalattice1 <- alpha_lattice(t = 15, 
                               k = 3, 
                               r = 4, 
                               l = 1, 
                               plotNumber = 101, 
                               locationNames = "GreenHouse", 
                               seed = 1247)
alphalattice1$infoDesign
head(alphalattice1$fieldBook, 10)

# Example 2: Generates an alpha design with 3 full blocks and 25 treatment.
# Size of IBlocks k = 5. 
# In this case, we show how to use the option data.
treatments <- paste("G-", 1:25, sep = "")
ENTRY <- 1:25
treatment_list <- data.frame(list(ENTRY = ENTRY, TREATMENT = treatments))
head(treatment_list) 
alphalattice2 <- alpha_lattice(t = 25,
                               k = 5,
                               r = 3, 
                               l = 1, 
                               plotNumber = 1001, 
                               locationNames = "A", 
                               seed = 1945,
                               data = treatment_list)
alphalattice2$infoDesign
head(alphalattice2$fieldBook, 10)

}
\references{
Edmondson., R. N. (2021). blocksdesign: Nested and crossed block designs for factorial and
unstructured treatment sets. https://CRAN.R-project.org/package=blocksdesign
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
