% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NHD_FUNCTIONS.R
\name{get_nhd}
\alias{get_nhd}
\title{Download and crop the National Hydrography Dataset.}
\usage{
get_nhd(template, label, res = "medium", raw.dir = "./RAW/NHD/",
  extraction.dir = "./EXTRACTIONS/NHD/", force.redo = FALSE)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve 
as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{res}{A character string defining the resolution of the NHD to download.
Either "medium" (the default), or "high".}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/NHD/".}

\item{extraction.dir}{A character string indicating where the extracted and cropped NHD shapefiles should be put.
The directory will be created if missing. Defaults to "./EXTRACTIONS/NHD/".}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}
}
\value{
A list of Spatial* objects extracted from the National Hydrography Dataset.
}
\description{
\code{get_nhd} returns a list of Spatial* objects extracted 
from the National Hydrography Dataset.
}

