% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_moments.R
\name{kmoments}
\alias{kmoments}
\alias{xmoments}
\alias{kmoment}
\alias{kcmoment}
\alias{kmean}
\alias{kstandev}
\alias{kvariance}
\alias{kskewness}
\alias{kkurtosis}
\alias{kekurtosis}
\title{Moments Associated To Kiener Distribution Parameters}
\usage{
kmoments(coefk, model = "K2", lengthx = NA, dgts = NULL,
  dimnames = FALSE)

xmoments(x, dgts = NULL, dimnames = FALSE)

kmoment(n, coefk, model = "K2", dgts = NULL)

kcmoment(n, coefk, model = "K2", dgts = NULL)

kmean(coefk, model = "K2", dgts = NULL)

kstandev(coefk, model = "K2", dgts = NULL)

kvariance(coefk, model = "K2", dgts = NULL)

kskewness(coefk, model = "K2", dgts = NULL)

kkurtosis(coefk, model = "K2", dgts = NULL)

kekurtosis(coefk, model = "K2", dgts = NULL)
}
\arguments{
\item{coefk}{vector. Parameters of the distribution of length 3 ("K1"),
length 4 (model = K2, K3, K4) and length 7 ("K7").}

\item{model}{character. Model type, either "K2", "K3" or "K4" if \code{coefk} is 
of length 4. Type "K1" and "K7" may be provided but are ignored.}

\item{lengthx}{integer. The length of the vector \code{x} used to calculate the parameters.
See the details for matrix and lists.}

\item{dgts}{integer. The rounding applied to the output.}

\item{dimnames}{boolean. Display dimnames.}

\item{x}{numeric. Vector of quantiles.}

\item{n}{integer. The moment order.}
}
\value{
Vectors \code{kmoments} and \code{xmoments} have the following structure 
(with a third letter \code{x} added to \code{xmoments}):

\item{ku}{Kurtosis.}
\item{ke}{Excess of kurtosis.}
\item{sk}{Skewness.}
\item{sd}{Standard deviation. Square root of the variance \code{u2}}
\item{m1}{Mean.}
\item{m2}{Non-central moment of second order.}
\item{m3}{Non-central moment of third order.}
\item{m4}{Non-central moment of fourth order.}
\item{u1}{Central moment of first order. Should be 0.}
\item{u2}{Central moment of second order. Variance}
\item{u3}{Central moment of third order.}
\item{u4}{Central moment of fourth order.}
\item{k1}{Cumulant of first order. Should be 0.}
\item{k2}{Cumulant of second order.}
\item{k3}{Cumulant of third order.}
\item{k4}{Cumulant of fourth order.}
\item{lh}{Length of x, from which NA values were removed.}
\item{......}{.}
}
\description{
Non-central moments, central moments, mean, standard deviation, variance, 
skewness, kurtosis, excess of kurtosis and cumulants associated to  
the parameters of Kiener distributions K1, K2, K3 and K4. 
All-in-one vectors \code{kmoments} (estimated from the parameters) 
and \code{xmoments} (estimated from the vector of quantiles) are provided.
}
\details{
The non-central moments \code{m1,m2,m3,m4,..,mn}, 
the central moments \code{u1,u2,u3,u4,..,un} (where u stands for mu in Greek)
and the cumulants \code{k1,k2,k3,k4,..,kn} (where k stands for kappa in Greek; 
not to be confounded with tail parameter "k" and models "K1", "K2", "K3", "K4") 
of order \eqn{n} exist only if \eqn{min(a, k, w) > n}. 
The mean \code{m1} exists only if \eqn{min(a, k, w) > 1}. 
The standard deviation \code{sd} and the variance \code{u2} exist only
if \eqn{min(a, k, w) > 2}. 
The skewness \code{sk} exists only if \eqn{min(a, k, w) > 3}. 
The kurtosis \code{ku} and the excess of kurtosis \code{ke} exist only 
if \eqn{min(a, k, w) > 4}. 

\code{coefk} may take five different forms :
\itemize{
  \item{\code{c(m, g, k) } of length 3 for distribution "K1".}
  \item{\code{c(m, g, a, w) } of length 4 for distribution "K2".}
  \item{\code{c(m, g, k, d) } of length 4 for distribution "K3".}
  \item{\code{c(m, g, k, e) } of length 4 for distribution "K4".}
  \item{\code{c(m, g, a, k, w, d, e) } of length 7 (sometimes referred as "K7") 
        provided by estimation/regression functions \code{paramkienerX}, 
        \code{fitkienerX}, \code{regkienerLX} (via \code{"reg$coefk"})
        and conversion function \code{pk2pk}.}        
}
Forms of length 3 and 7 are automatically recognized and do not require 
\code{model = "K1"} or \code{"K7"} which are ignored. 
Forms of length 4 require \code{model = "K2"}, \code{"K3"} or \code{"K4"}. 
Visit \code{\link{pk2pk}} for details on the parameter conversion function 
used within \code{kmoments}.

\code{xmoments} and \code{kmoments} provide all-in-one vectors. 

\code{xmoments} is the traditional mean of squares, cubic and power 4 functions 
of non-central and central values of x, from which NA values have been removed. 
Therefore, length of x ignores NA values and may be different from the true length.

\code{kmoments} calls every specialized functions from order 1 to order 4 and 
uses the estimated parameters as inputs, not the initial dataset \code{x}.
As it does not know \emph{a priori} the length of \code{x}, this latest can 
be provided separately via \code{lengthx = length(x)}, \code{lengthx = nrow(x)} 
and \code{lengthx = sapply(x, length)} if \code{x} is a vector, a matrix or a list. 
See the examples.
}
\examples{

## Example 1
kcmoment(2, c(-1, 1, 6, 9), model = "K2")
kcmoment(2, c(-1, 1, 7.2, -0.2/7.2), model = "K3")
kcmoment(2, c(-1, 1, 7.2, -0.2), model = "K4")
kcmoment(2, c(-1, 1, 6, 7.2, 9, -0.2/7.2, -0.2))
kvariance(c(-1, 1, 6, 9))
kmoments(c(-1, 1, 6, 9), dgts = 3)

## Example 2: "K2" and "K7" are preferred input formats for kmoments
## Moments fall at expected parameter values (=> NA).
## apply and direct calculation (= transpose)
(mat4 <- matrix(c(rep(0,4), rep(1,4), c(1.9,2.1,3.9,4.1), rep(5,4)),
                nrow = 4, byrow = TRUE, 
                dimnames = list(c("m","g","a","w"), paste0("b",1:4))))
round(mat7 <- apply(mat4, 2, pk2pk), 2)
round(rbind(mat7, apply(mat7, 2, kmoments)[2:5,]), 2) 
round(cbind(t(mat7), kmoments(t(mat7), dgts = 2)[,2:5]), 2) 

## Example 3: Matrix, timeSeries, xts, zoo + apply 
matret    <- 100*diff(log((EuStockMarkets)))
(matcoefk <- apply(matret, 2, paramkienerX5, dgts = 2))
(matmomk  <- apply(matcoefk, 2, kmoments, lengthx = nrow(matret), dgts = 2))
(matmomx  <- apply(matret, 2, xmoments, dgts = 2))
rbind(matcoefk, matmomk[2:5,], matmomx[2:5,])

## Example 4: List + direct calculation = transpose
DS   <- getDSdata() ; dimdim(DS) ; class(DS)
(pDS <- paramkienerX5(DS, dimnames = FALSE))
(kDS <- kmoments(pDS, lengthx = sapply(DS, length), dgts = 3))
(xDS <- xmoments( DS, dgts = 3))
cbind(pDS, kDS[,2:5], xDS[,2:5])


}
\seealso{
\code{\link{pk2pk}}, \code{\link{paramkienerX}}, \code{\link{regkienerLX}}.
}
