% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/d_conversion.R
\name{pk2pk}
\alias{pk2pk}
\title{Global Conversion Function Between Kiener Distribution Parameters}
\usage{
pk2pk(coefk, model = "k2", to = "k7", roundk = 9)
}
\arguments{
\item{coefk}{vectors of numeric of length 3, 4 or 7.}

\item{model}{character. Either "k1", "k2", "k3", "k4", "k7".}

\item{to}{character. Either "k1", "k2", "k3", "k4", "k7".}

\item{roundk}{integer. The rounding applied to the output.}
}
\description{
A conversion function between the parameter vectors of Kiener distributions
of type I: \code{c(m, g, k)}, type II: \code{c(m, g, a, w)},
type III: \code{c(m, g, k, d)} and type IV: \code{c(m, g, k, e)} to and from
\code{coefk = c(m, g, a, k, w, d, e)} extracted from \code{\link{regkienerLX}}.
}
\details{
Kiener distributions use the following parameters, some of them being redundant.
See also \code{\link{aw2k}} for the formulas and
the conversion between parameters:
\itemize{
  \item{ \code{m} (mu) is the median of the distribution,. }
  \item{ \code{g} (gamma) is the scale parameter. }
  \item{ \code{a} (alpha) is the left tail parameter. }
  \item{ \code{k} (kappa) is the harmonic mean of \code{a} and \code{w}
         and describes a global tail parameter. }
  \item{ \code{w} (omega) is the right tail parameter. }
  \item{ \code{d} (delta) is the distorsion parameter. }
  \item{ \code{e} (epsilon) is the eccentricity parameter. }
}

\code{pk2pk()} performs the conversion between the various representation, from and to:
\itemize{
  \item{ type I: \code{\link{kiener1}} or code{"k1"}: c(m, g, k) }
  \item{ type II: \code{\link{kiener1}} or code{"k2"}: c(m, g, a, w) }
  \item{ type III: \code{\link{kiener1}} or code{"k3"}: c(m, g, k, d) }
  \item{ type IV: \code{\link{kiener1}} or code{"k4"}: c(m, g, k, e) }
  \item{ \code{coefk}, here code{"k7"}, extracted from object of class
         \code{clregk} like \code{\link{regkienerLX}}: c(m, g, a, k, w, d, e) }
}

\code{coefk} can take any of the above form. When length(coefk) is 4,
\code{model = "k2", "k3" or "k4"} is required to differentiate the three models.
When length(coefk) is 3 or 7, recognition is automatic and
\code{model = "k1" or "k7"} is not required (and is ignored).
When a vector of type \code{coefk "k7"} is used as input, the vector is assumed
to be correct and there is no check of the consistency between the
parameters \code{a, k, w, d} and \code{e}.

The output may be any of the above forms. Default is \code{"k7" = c(m, g, a, k, w, d, e)}
which is \code{coefk} provided by the regression function \code{\link{regkienerLX}}
and is widely used in plotting and subsequent calculations.

An integer rounding parameter is provided trough \code{roundk}. Default is no rounding.
}
\examples{
## Example 1
c2 <- c(1, 2, 3, 5)
pk2pk(c2, model = "k2", to = "k1") # loose the asymmetry.
pk2pk(c2, model = "k2", to = "k2")
pk2pk(c2, model = "k2", to = "k3")
pk2pk(c2, model = "k2", to = "k4")
pk2pk(c2, model = "k2", to = "k4")
(c7 <- pk2pk(c2, model = "k2", to = "k7", roundk = 3))
pk2pk(c7, model = "k7", to = "k2")

## Example 2 ("k2" to "k7")
b08 <- c(-1, 1, 0.6, 0.8)
b10 <- c(-1, 1, 1.0, 1.2)
b15 <- c(-1, 1, 1.5, 1.7)
b20 <- c(-1, 1, 2.0, 2.2)
b25 <- c(-1, 1, 2.5, 2.7)
b30 <- c(-1, 1, 3.0, 3.2)
b35 <- c(-1, 1, 3.5, 3.7)
b40 <- c(-1, 1, 4.0, 4.2)
b45 <- c(-1, 1, 4.5, 4.7)
round(apply(cbind(b08, b10, b15, b20, b25, b30, b35, b40, b45), 2, pk2pk), 3)
}
\seealso{
The local conversion functions \code{\link{aw2k}},
Kiener distributions of type I, II, III and IV: \code{\link{kiener1}},
\code{\link{kiener2}}, \code{\link{kiener3}}, \code{\link{kiener4}}
}

