% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probcub00.R
\name{probcub00}
\alias{probcub00}
\title{Probability distribution of a CUB model without covariates}
\usage{
probcub00(m,pai,csi)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{pai}{Uncertainty parameter}

\item{csi}{Feeling parameter}
}
\value{
The vector of the probability distribution of a CUB model.
}
\description{
Compute the probability distribution of a CUB model without covariates.
}
\examples{
m<-9
pai<-0.3
csi<-0.8
pr<-probcub00(m,pai,csi)
plot(1:m,pr,type="h",main="CUB probability distribution",xlab="Ordinal categories")
points(1:m,pr,pch=19)
}
\references{
Piccolo D. (2003). On the moments of a mixture of uniform and shifted binomial random variables.
\emph{Quaderni di Statistica}, \bold{5}, 85--104\cr
}
\seealso{
\code{\link{bitcsi}}, \code{\link{probcub0q}}, \code{\link{probcubp0}}, \code{\link{probcubpq}}
}
\keyword{distribution}
