% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDch.R
\name{IDch}
\alias{IDch}
\title{Retrieves ID of children of ego}
\usage{
IDch(idego, dLH, keep_ego = FALSE)
}
\arguments{
\item{idego}{ID of ego(s)}

\item{dLH}{Name of database. If dLH is missing, dataLH_F is used.}

\item{keep_ego}{Option to link show ID of ego together with ID of mother}
}
\value{
ID of children. If ego has no children or IDs of children are not included
in database, numeric(0) is returned. If keep_ego=TRUE, a data frame is returned with the
following columns: IDego, ID of mother of children, ID of father of
children, ID of children, sex of children.
}
\description{
Retrieves ID of children of ego or children of vector of egos
}
\examples{

data(dataLH_F,package = "Families")
IDch(idego=1)
id <- sample (dataLH_F$ID[dataLH_F$gen==1],10)
IDch(idego=sort(id),keep_ego=TRUE)

}
\author{
Frans Willekens
}
