% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DarterMahon.R
\docType{data}
\name{DarterMahon}
\alias{DarterMahon}
\title{Catch and effort data for Fantail Darter.}
\format{A data frame with 7 observations on the following 2 variables.
 \describe{
   \item{catch}{Catch of Fantail Darter.} 
   \item{effort}{Constant electrofishing effort.} 
 }}
\source{
From Mahon, R. 1980. Accuracy of catch-effort methods for estimating fish density and biomass in streams. Environmental Biology of Fishes. 4:343-363.
}
\description{
Catch and effort data for Fantail Darter (\emph{Etheostoma flabellare}) from seven removal events conducted by Mahon (1980).
}
\details{
Catch (number of fish) was recorded.  Effort was a constant amount of electrofishing for each sampling event and is, thus, entered as a constant value of 1.

These data are used in many publications because the stream section was rotenoned following the removal surveys to determine a known population size of 1151 individuals.
}
\section{Topic(s)}{

 \itemize{
   \item Population size 
   \item Abundance 
   \item Depletion methods
   \item Leslie method
   \item DeLury method 
   \item Catchability
 }
}

\examples{
data(DarterMahon)
str(DarterMahon)
head(DarterMahon)

}
\concept{Abundance}
\concept{Catchability}
\concept{DeLury}
\concept{Depletion}
\concept{Leslie}
\concept{Population Size}
\keyword{datasets}
