% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/YPerchGL.R
\docType{data}
\name{YPerchGL}
\alias{YPerchGL}
\title{Lengths and weights of Yellow Perch from Grafton Lake by year.}
\format{A data frame with 100 observations on the following 3 variables:
 \describe{
   \item{fl}{Fork Length (nearest mm) at capture.}
   \item{w}{Weight (nearest 0.1 g) at capture.}
   \item{year}{Year of capture (1994 or 2000).}
 }}
\source{
Extracted (approximately) from Figure 3 in Brylinsky, M. 2001. An evaluation of changes in the yellow perch (\emph{Perca flavescens}) population of Grafton Lake, Kejimkujik National Park, after dam removal.  Technical Report Publication No. 59, Acadia Centre for Estuarine Research. 2001.
}
\description{
Yellow Perch (\emph{Perca flavescens}) fork lengths and weights seperated by year.
}
\section{Topic(s)}{

 \itemize{
   \item Length-weight
 }
}
\examples{
data(YPerchGL)
str(YPerchGL)
head(YPerchGL)
op <- par(mfrow=c(1,2),pch=19)
plot(w~fl,data=YPerchGL,subset=year==1994,main="1994")
plot(w~fl,data=YPerchGL,subset=year==2000,main="2000")
par(op)
}
\concept{
'Length-Weight'
}
\keyword{datasets}

