% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{diags}
\alias{diags}
\title{Extract diagonals from a matrix.}
\usage{
diags(
  x,
  which = 0,
  incl.labels = c("none", "row", "column"),
  val.name = "value",
  label.name = "label"
)
}
\arguments{
\item{x}{A matrix with more than one row AND more than one column.}

\item{which}{A single numeric that indicates which diagonal to extract. A value of zero extracts the main diagonal, whereas negative values extract diagonals from the upper triangle and positive values extract diagonals from the lower triangle. Diagonals further from the main diagonal have \code{which} values further from zero. If \code{is.null(which)}, then a matrix of diagonal indices for \code{which} is shown.}

\item{incl.labels}{A single string that indicates whether \code{"row"}, \code{"column"}, or no (\code{"none"}) labels from \code{x} should be returned with the values on the diagonal. Will return numeric values if the labels are all diagonal, otherwise character labels are returned.}

\item{val.name}{A single string to name the variable that contains the values from the diagonal in the returned data.frame.}

\item{label.name}{A single string to name the variable that contains the labels in the returned data.frame (see \code{incl.labels})}
}
\value{
A data.frame with one variable that contains the values from the chosen diagonal of \code{x} and, optionally, a second variable that contains the chosen labels for those values.
}
\description{
Extract diagonals from a matrix.
}
\examples{
## Square numeric matrix
mat1 <- matrix(1:16,nrow=4)
colnames(mat1) <- LETTERS[1:ncol(mat1)]
rownames(mat1) <- 1:nrow(mat1)
mat1
diags(mat1,which=NULL)
diags(mat1)
diags(mat1,which=-1)
diags(mat1,which=2)
diags(mat1,incl.labels="row")
diags(mat1,which=2,incl.labels="row")
diags(mat1,which=2,incl.labels="col")
( tmp <- diags(mat1,which=2,incl.labels="row",val.name="Freq",label.name="age") )
str(tmp)

## Rectangular numeric matrix
mat2 <- matrix(1:20,nrow=4)
colnames(mat2) <- LETTERS[1:ncol(mat2)]
rownames(mat2) <- 1:nrow(mat2)
mat2
diags(mat2,which=NULL)
diags(mat2,which=-1,incl.labels="row")
diags(mat2,which=2,incl.labels="row")
diags(mat2,which=-4,incl.labels="col")

## Rectangular character matrix
mat3 <- matrix(LETTERS[1:24],nrow=3)
colnames(mat3) <- letters[1:ncol(mat3)]
rownames(mat3) <- 1:nrow(mat3)
mat3
diags(mat3,which=NULL)
diags(mat3,which=-1,incl.labels="row")
diags(mat3,which=2,incl.labels="row")
diags(mat3,which=-4,incl.labels="col")

}
\author{
Derek H. Ogle, \email{derek@derekogle.com}, but relied heavily on \url{http://stackoverflow.com/a/27935808/1123933}.
}
\keyword{manip}
