% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foci.R
\name{foci}
\alias{foci}
\title{Variable selection by the FOCI algorithm}
\usage{
foci(
  Y,
  X,
  num_features = NULL,
  stop = TRUE,
  na.rm = TRUE,
  factor = TRUE,
  standardize = TRUE
)
}
\arguments{
\item{Y}{Vector of responses (length n)}

\item{X}{Matrix of predictors (n by p)}

\item{num_features}{Number of variables to be selected, cannot be larger than p. The default value is NULL and in that
case it will be set equal to p. If stop == TRUE (see below), then num_features is irrelevant.}

\item{stop}{Stops at the first instance of negative codec, if TRUE.}

\item{na.rm}{Removes NAs if TRUE.}

\item{factor}{Converts factor variables to integers if TRUE.}

\item{standardize}{Standardize covariates if TRUE.}
}
\value{
A vector of selected covariates, in decreasing order of predictive power.
}
\description{
foci is a variable selection algorithm based on the measure of conditional dependence \code{\link{codec}}.
}
\details{
foci is a forward stepwise algorithm that uses the conditional dependence coefficient (\code{\link{codec}})
defined in Azadkla and Chatterjee (2019) at each step, instead of the multiple correlation coefficient
as in ordinary forward stepwise. If stop == TRUE, the process is stopped at the first instance of
nonpositive codec, thereby selecting subset of variables. Otherwise, a set of covariates of size
num_features, ordered according to predictive power (as measured by codec) is produced.
}
\examples{
# Example 1
n = 1000
p = 100
x <- matrix(rnorm(n * p), nrow = n)
y <- x[, 1] * x[, 10] + x[, 20]^2
# with num_features equal to 3 and stop equal to FALSE, foci will give a list of
# three selected features
result1 = foci(y, x, num_features = 3, stop = FALSE)
result1
# Example 2
# foci for the same example, this time it will stop according to its stopping rule.
result2 = foci(y, x)
result2

}
\references{
Azadkia, M. and Chatterjee, S. (2019). A simple measure of conditional dependence. \url{https://arxiv.org/pdf/1910.12327.pdf}
}
\seealso{
\code{\link{codec}}
}
\author{
Mona Azadkia and Sourav Chatterjee
}
