% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spClipPoint.R
\name{spClipPoint}
\alias{spClipPoint}
\title{Spatial - Clip (intersect) point vector layer with polygon vector layer.}
\usage{
spClipPoint(
  xyplt,
  xyplt_dsn = NULL,
  uniqueid = "PLT_CN",
  clippolyv,
  clippolyv_dsn = NULL,
  clippolyv.filter = NULL,
  showext = FALSE,
  keepNA = FALSE,
  returnsp = TRUE,
  othertabnms = NULL,
  stopifnotin = TRUE,
  savedata = FALSE,
  exportsp = FALSE,
  spMakeSpatial_opts = NULL,
  savedata_opts = NULL
)
}
\arguments{
\item{xyplt}{sf R object or String. Point data to clip. Can be a spatial
points object, full pathname to a shapefile, or name of a layer within a
database.}

\item{xyplt_dsn}{String. Data source name (dsn; e.g., sqlite or shapefile
pathname) of layer to clip. The dsn varies by driver. See gdal OGR vector
formats (https://www.gdal.org/ogr_formats.html).}

\item{uniqueid}{String.* Unique identifier of xyplt rows.}

\item{clippolyv}{sf R object or String. Name of clipping polygon spatial
polygon object, full path to shapefile, or name of a layer within a
database.}

\item{clippolyv_dsn}{String. Data source name (dsn; e.g., sqlite or
shapefile pathname) of clipping polygon. The dsn varies by driver. See gdal
OGR vector formats (https://www.gdal.org/ogr_formats.html).}

\item{clippolyv.filter}{String. Filter to subset clippolyv spatial layer.}

\item{showext}{Logical. If TRUE, layer extents are displayed in plot window.}

\item{keepNA}{Logical. If TRUE, keep NA values after data intersection.}

\item{returnsp}{Logical. If TRUE, returns sf object of points. If FALSE,
returns data frame of points (i.e., drops sf geometry).}

\item{othertabnms}{String vector. Name(s) of R objects, comma-delimited
files, or database layers to subset. Must include quotes (e.g.,
othertabnms=c("tree", "cond")).}

\item{stopifnotin}{Logical. If TRUE, stops if boundaries do not overlap.  If
FALSE, returns NULL.}

\item{savedata}{Logical. If TRUE, save data to outfolder.}

\item{exportsp}{Logical. If TRUE, the clipped spatial point data are
exported.}

\item{spMakeSpatial_opts}{List. See help(spMakeSpatial_options()) for a list
of options. Use to convert X/Y values to simple feature (sf) coordinates.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options for saving data. If out_layer = NULL, default = 'pntclip'.}
}
\value{
A list of the following objects:

\item{clip_xyplt}{ sf object. The input xyplt, clipped to polygon boundary
layer.  The projection will be same as clippolyv projection. }
\item{xy.uniqueid}{ String. Unique identifier of clip_xy. }
\item{clip_polyv}{ SpatialPolygonsDataFrame. The polygon boundary layer used
for clipping. } \item{clip_tabs}{ Data frame(s). Other tables in intabs
clipped to boundary. }

If exportsp=TRUE, the sf object will be written to out_dsn (See note).
}
\description{
Wrapper for sf::st_intersection, to clip (intersect) point vector layer with
a polygon vector layer.
}
\details{
The sf::st_intersection function is used to clip points. \cr

If the projection of clippolyv is not the same as the xyplt, the xyplt layer
layer will be reprojected to the same projection as the clippoly before
intersection.
}
\note{
On-the-fly projection conversion\cr The spTransform (sf) method is
used for on-the-fly map projection conversion and datum transformation using
PROJ.4 arguments. Datum transformation only occurs if the +datum tag is
present in the both the from and to PROJ.4 strings. The +towgs84 tag is used
when no datum transformation is needed. PROJ.4 transformations assume NAD83
and WGS84 are identical unless other transformation parameters are
specified.  Be aware, providing inaccurate or incomplete CRS information may
lead to erroneous data shifts when reprojecting. See spTransform help
documentation for more details.

ESRI Shapefile Driver\cr If exportsp=TRUE:\cr The st_write (sf) function
is called. If out_fmt="shp", the ESRI Shapefile driver truncates variable
names to 10 characters or less. Variable names are changed before export
using an internal function (trunc10shp). If sf object has more than 1
record, it will be returned but not exported.
}
\examples{
# Get point data from WYplt data in FIESTA
WYplt <- FIESTA::WYplt

# Get polygon vector layer from FIESTA external data
WYbhdistfn <- system.file("extdata",
                          "sp_data/WYbighorn_districtbnd.shp",
                          package = "FIESTA")

# Extract points from polygon vector layer
xyext <- spClipPoint(xyplt = WYplt,
                     clippolyv = WYbhdistfn,
                     clippolyv.filter = "DISTRICTNU == '03'",
                     uniqueid = "CN",
                     spMakeSpatial_opts = list(xvar = "LON_PUBLIC",
                                               yvar = "LAT_PUBLIC",
                                               xy.crs = 4269))
names(xyext)
xyplt <- xyext$clip_xyplt
polyv <- xyext$clip_polyv

# Plot extracted values of national forest district
plot(sf::st_geometry(polyv))
plot(sf::st_geometry(xyplt), add = TRUE)
}
\author{
Tracey S. Frescino
}
\keyword{data}
