% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sabr_hagan2002.R
\name{SabrHagan2002}
\alias{SabrHagan2002}
\title{Calculate the equivalent BS volatility (Hagan et al. 2002) for
  the Stochatic-Alpha-Beta-Rho (SABR) model}
\usage{
SabrHagan2002(
  strike = forward,
  spot,
  texp = 1,
  sigma,
  vov = 0,
  rho = 0,
  beta = 1,
  intr = 0,
  divr = 0,
  cp = NULL,
  forward = spot * exp(-divr * texp)/df,
  df = exp(-intr * texp)
)
}
\arguments{
\item{strike}{(vector of) strike price}

\item{spot}{(vector of) spot price}

\item{texp}{(vector of) time to expiry}

\item{sigma}{(vector of) volatility}

\item{vov}{(vector of) vol-of-vol}

\item{rho}{(vector of) correlation}

\item{beta}{(vector of) beta}

\item{intr}{interest rate}

\item{divr}{dividend rate}

\item{cp}{call/put sign. \code{NULL} for BS vol (default), \code{1} for call price, \code{-1} for put price.}

\item{forward}{forward price. If given, \code{forward} overrides \code{spot}}

\item{df}{discount factor. If given, \code{df} overrides \code{intr}}
}
\value{
BS volatility or option price based on \code{cp}
}
\description{
Calculate the equivalent BS volatility (Hagan et al. 2002) for
  the Stochatic-Alpha-Beta-Rho (SABR) model
}
\examples{
sigma <- 0.25
vov <- 0.3
rho <- -0.8
beta <- 0.3
texp <- 10
strike <- seq(0.1, 2, 0.1)
FER::SabrHagan2002(strike, 1, texp, sigma, vov, rho, beta)
FER::SabrHagan2002(strike, 1, texp, sigma, vov, rho, beta, cp=1)

}
\references{
Hagan, P. S., Kumar, D., Lesniewski, A. S., & Woodward, D. E. (2002).
  Managing Smile Risk. Wilmott, September, 84-108.
}
