% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{resid.femlm}
\alias{resid.femlm}
\alias{residuals.femlm}
\title{Extracts residuals from a femlm object}
\usage{
\method{resid}{femlm}(object, ...)

\method{residuals}{femlm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{femlm}. Typically the result of a \code{\link[FENmlm]{femlm}} estimation.}

\item{...}{Not currently used.}
}
\value{
It returns a numeric vector of the length the number of observations used for the estimation.
}
\description{
This function extracts residuals from a fitted model estimated with \code{\link[FENmlm]{femlm}}.
}
\details{
The residuals returned are the difference between the dependent variable and the expected predictor.
}
\examples{

# simple estimation on iris data, clustering by "Species"
res_poisson = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
                    Petal.Width | Species, iris)

# we plot the residuals
plot(resid(res_poisson))

}
\seealso{
\code{\link[FENmlm]{femlm}}, \code{\link[FENmlm]{fitted.femlm}}, \code{\link[FENmlm]{predict.femlm}}, \code{\link[FENmlm]{summary.femlm}}, \code{\link[FENmlm]{vcov.femlm}}, \code{\link[FENmlm]{getFE}}.
}
\author{
Laurent Berge
}
