% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{truncateTime}
\alias{truncateTime}
\title{Function to truncate time in functional data}
\usage{
truncateTime(funVar, time, newtime, data)
}
\arguments{
\item{funVar}{names of functional variables that should be truncated}

\item{time}{name of time variable}

\item{newtime}{new time vector that should be used. Must be part of the old time-line.}

\item{data}{list containing all the data}
}
\value{
A list with the data containing all variables of the original dataset
with the variables of \code{funVar} truncated according to \code{newtime}.
}
\description{
Function to truncate time in functional data
}
\note{
All variables that are not part if \code{funVar}, or \code{time}
are simply copied into the new data list
}
\examples{
if(require(fda)){
  dat <- fda::growth
  dat$hgtm <- t(dat$hgtm[,1:10])
  dat$hgtf <- t(dat$hgtf[,1:10])

  ## only use time-points 1:16 of variable age
  datTr <- truncateTime(funVar=c("hgtm","hgtf"), time="age", newtime=1:16, data=dat)

  \dontrun{
  par(mfrow=c(1,2))
  with(dat, funplot(age, hgtm, main="Original data"))
  with(datTr, funplot(age, hgtm, main="Yearly data"))
  par(mfrow=c(1,1))
  }
}
}

