% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.p.fdr.R
\name{summary.p.fdr}
\alias{summary.p.fdr}
\title{Summary of p.fdr.object}
\usage{
\method{summary}{p.fdr}(object, digits = 5, ...)
}
\arguments{
\item{object}{A list of output from the p.fdr function.}

\item{digits}{A numeric value for the number of desired digits in the summary output. Defaults to 3.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A list containing the following components:

\item{Range}{The range on the false discovery rates.}

\item{Significant Findings}{The number of significant findings. Found using the adjusted p-values and the given threshold. This is also the number of times we decide to reject the null hypothesis that the data is generated from a standard normal distribution.}

\item{Inconclusive Findings}{The number of inconclusive findings. Found using the adjusted p-values and the given threshold. This is also the number of times we fail to reject the null hypothesis that the data is generated from a standard normal distribution.}

\item{Assumed/Estimated pi0}{the assumed or estimated pi0 value depending on how the p.fdr function was run.}

\item{Number of Tests}{The total number of multiple comparison tests completed.}

\item{Adjustment Method}{The adjustment method used in the p.fdr function. }
}
\description{
This function summarizes a p.fdr object.
}
\details{
We run into errors or warnings when
}
\examples{

# Example 1
pi0 = 0.8
pi1 = 1-pi0
n = 10
n.0 = ceiling(n*pi0)
n.1 = n-n.0

sim.data = c(rnorm(n.1,5,1),rnorm(n.0,0,1))
sim.data.p = 2*pnorm(-abs(sim.data))

fdr.output = p.fdr(pvalues=sim.data.p, adjust.method="BH")

summary(fdr.output)


}
\references{
\insertRef{Rpack:bibtex}{Rdpack}

\insertRef{R}{FDRestimation}

\insertRef{murray2020false}{FDRestimation}
}
\seealso{
\code{\link{plot.p.fdr}, \link{p.fdr}, \link{get.pi0}}
}
\concept{summary FDR adjusted p-values}
\keyword{FDR}
\keyword{summary}
