% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{read-write-fcnndataset}
\alias{read-write-fcnndataset}
\alias{read.fcnndataset}
\alias{write.fcnndataset}
\title{Reading and writing datasets in the FCNN format}
\usage{
read.fcnndataset(fname)

write.fcnndataset(fname, input, output)
}
\arguments{
\item{fname}{character string with the filename}

\item{input}{numeric matrix, each row corresponds to one input vector}

\item{output}{numeric matrix with rows corresponding to expected outputs,
the number of rows must be equal to the number of input rows}
}
\value{
\code{read.fcnndataset} returns a dataframe.

        \code{write.fcnndataset} does not return.
}
\description{
These functions can be used to read and write datasets from/to a text file
in the FCNN format. Datasets in the similar FANN format (comments are not
supported by FANN) can also be read by \code{read.fcnndataset}.
}
\details{
Files are organised as follows:
\itemize{
 \item The first comment (beginning with \code{#}) is the dataset information (ignored on read),
 \item three numbers determine: number of records, no. of inputs and no. of outputs,
 \item each data record has two or three lines:
    \itemize{
     \item (optional) record information in a comment (beginning with \code{#}),
     \item line with input values,
     \item line with output values.
     }
 }
}
\examples{

# set up the XOR problem inputs and outputs
inp <- c(0, 0, 1, 1, 0, 1, 0, 1)
dim(inp) <- c(4, 2)
outp <- c(0, 1, 1, 0)
dim(outp) <- c(4, 1)
# write dataset
write.fcnndataset("xor.dat", inp, outp)
# show the output file
file.show("xor.dat")
# read dataset
xordf <- read.fcnndataset("xor.dat")
# show the imported dataset
show(xordf)

}

