% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.gmjmcmc}
\alias{predict.gmjmcmc}
\title{Predict using a gmjmcmc result object.}
\usage{
\method{predict}{gmjmcmc}(
  object,
  x,
  link = function(x) x,
  quantiles = c(0.025, 0.5, 0.975),
  pop = NULL,
  tol = 1e-07,
  ...
)
}
\arguments{
\item{object}{The model to use.}

\item{x}{The new data to use for the prediction, a matrix where each row is an observation.}

\item{link}{The link function to use}

\item{quantiles}{The quantiles to calculate credible intervals for the posterior modes (in model space).}

\item{pop}{The population to plot, defaults to last}

\item{tol}{The tolerance to use for the correlation when finding equivalent features, default is 0.0000001}

\item{...}{Not used.}
}
\value{
A list containing aggregated predictions and per model predictions.
\item{aggr}{Aggregated predictions with mean and quantiles.}
\item{preds}{A list of lists containing individual predictions per model per population in object.}
}
\description{
Predict using a gmjmcmc result object.
}
\examples{
result <- gmjmcmc(
 matrix(rnorm(600), 100),
 P = 2,
 gaussian.loglik,
 loglik.alpha = gaussian.loglik.alpha,
 c("p0", "exp_dbl")
)
preds <- predict(result, matrix(rnorm(600), 100))


}
