% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mjmcmc.R
\name{mjmcmc}
\alias{mjmcmc}
\title{Main algorithm for MJMCMC (Genetically Modified MJMCMC)}
\usage{
mjmcmc(
  data,
  loglik.pi = gaussian.loglik,
  N = 100,
  probs = NULL,
  params = NULL,
  sub = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{A matrix containing the data to use in the algorithm,
first column should be the dependent variable,
and the rest of the columns should be the independent variables.}

\item{loglik.pi}{The (log) density to explore}

\item{N}{The number of iterations to run for}

\item{probs}{A list of the various probability vectors to use}

\item{params}{A list of the various parameters for all the parts of the algorithm}

\item{sub}{An indicator that if the likelihood is inexact and should be improved each model visit (EXPERIMENTAL!)}

\item{verbose}{A logical denoting if messages should be printed}
}
\value{
A list containing the following elements:
\item{models}{All visited models.}
\item{accept}{Average acceptance rate of the chain.}
\item{lo.models}{All models visited during local optimization.}
\item{best.crit}{The highest log marginal probability of the visited models.}
\item{marg.probs}{Marginal probabilities of the features.}
\item{model.probs}{Marginal probabilities of all of the visited models.}
\item{model.probs.idx}{Indices of unique visited models.}
\item{populations}{The covariates represented as a list of features.}
}
\description{
Main algorithm for MJMCMC (Genetically Modified MJMCMC)
}
\examples{
result <- mjmcmc(matrix(rnorm(600), 100), gaussian.loglik)
summary(result)
plot(result)

}
