#' FACTscorer
#'
#' Scores the FACT and FACIT family of QoL patient-reported outcome measures
#'
#' Provides functions to score the Functional Assessment of Cancer Therapy
#' (FACT) and Functional Assessment of Chronic Illness Therapy (FACIT)
#' patient-reported outcome (PRO) measures.  The questionnaires themselves can
#' be downloaded from www.FACIT.org.  For most of the FACIT questionnaires,
#' FACIT.org provides scoring syntax for use with commercial statistical
#' software (SAS and SPSS).  The FACTscorer R package is intented to serve as
#' a free, reliable alternative for those without access to SAS or SPSS.
#' Additionally, it will allow R users to both score and analyze the FACT and
#' FACIT scales in R, avoiding the time-consuming and and error-prone process
#' of transferring the data back-and-forth between statistical softwares.
#' Finally, use of the FACTscorer package will prevent many sources of scoring
#' error common when using SAS and/or SPSS syntax (e.g., copy-paste errors and
#' other accidental modifications to the syntax).
#'
#' @name FACTscorer
#' @docType package
#'
NULL

