% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Logistic}
\alias{Logistic}
\alias{dLogistic}
\alias{eLogistic}
\alias{lLogistic}
\alias{pLogistic}
\alias{qLogistic}
\alias{rLogistic}
\title{The Logistic Distribution.}
\usage{
dLogistic(x, location = 0, scale = 1, params = list(location = 0, scale =
  1))

pLogistic(q, location = 0, scale = 1, params = list(location = 0, scale =
  1))

qLogistic(p, location = 0, scale = 1, params = list(location = 0, scale =
  1))

rLogistic(n, location = 0, scale = 1, params = list(location = 0, scale =
  1))

eLogistic(X, w, method = "numerical.MLE")

lLogistic(X, w, location = 0, scale = 1, params = list(location = 0, scale
  = 1), logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{location}{location parameter.}

\item{scale}{scale parameter.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lLogistic gives log likelihood.}

\item{...}{other parameters}
}
\value{
dLogistic gives the density; pLogistic gives the distribution function;
qLogistic gives the quantile function; rLogistic generates random variables;
eLogistic estimate the parameters
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Logistic distribution
}
\details{
Logistic Distribution

See \href{../doc/Distributions-Logistic.html}{Distributions-Logistic}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
location <- 1.5
scale <- 0.5
X <- rLogistic(n, location, scale)
(est.par <- eLogistic(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dLogistic(den.x,location=est.par$location,scale=est.par$scale)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qLogistic((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(-5,5), ylim = c(-5,5))
abline(0,1)

plot((1:n-0.5)/n, pLogistic(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(location=1, scale=2)
X <- rLogistic(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eLogistic(X,w) # estimated parameters of weighted sample
eLogistic(X) # estimated parameters of unweighted sample

# Extracting location or scale parameters
est.par[attributes(est.par)$par.type=="location"]
est.par[attributes(est.par)$par.type=="scale"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rLogistic,edist=eLogistic,n = 1000, rep.num = 1e3,
   params = list(location=1, scale=2))

# evaluate the precision of estimation by Hessian matrix
X <- rLogistic(1000, location, scale)
(est.par <- eLogistic(X))
H <- attributes(eLogistic(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lLogistic(X,param = est.par)
lLogistic(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

