% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WbinoCI.R
\name{WbinoCI}
\alias{WbinoCI}
\title{An Admissible Exact Confidence Interval for the Bnomial Proportion}
\usage{
WbinoCI(x, n, conf.level = 0.95, details = FALSE)
}
\arguments{
\item{x}{the number of success or the observed data.}

\item{n}{the sample size.}

\item{conf.level}{Confidence level. The default is 0.95.}

\item{details}{TRUE/FALSE, can be abbreviated. To choose whether to compute
the confidence interval for the whole sample points and output the infimum
coverage probability. The default is FALSE.}
}
\value{
A list which contains the confidence interval (CI) of the sample
point and the confidence intervals (CIM) for all the points and the icp.
}
\description{
An admissible exact confidence interval of level 1-alpha is
constructed for the binomial proportion p. This function can be used to
calculate the interval constructed method proposed by Wang (2014).
}
\details{
Suppose X~bino(n,p), the sample space of X is \{0,1,...,n\}. Wang
(2014) proposed an admissible interval which is obtained by uniformly
shrinking the initial 1-alpha Clopper-Pearson interval from the middle to
both sides of the sample space iteratively. This interval is admissible so
that any proper sub-interval of it cannot assure the confidence coefficient.
This means the interval cannot be shortened anymore.
}
\examples{
WbinoCI(x=2,n=5,conf.level=0.95,details=TRUE)
WbinoCI(x=2,n=5,conf.level=0.95)
}
\references{
Clopper, C. J. and Pearson, E. S. (1934). The use of confidence
or fiducial limits in the case of the binomial. "Biometrika" 26: 404-413.

Wang, W. (2014). An iterative construction of confidence
intervals for a proportion. "Statistica Sinica" 24: 1389-1410.
}
