EviewsR Package created by Sagiru Mati
================

# About the Author

The author of this package, **Sagiru Mati**, obtained his PhD in
Economics from the Near East University, North Cyprus. He works at the
Department of Economics, Yusuf Maitama Sule (Northwest) University,
Kano, Nigeria. Please visit his [website](https://smati.com.ng) for more
details.

Please follow his publications on **ORCID: 0000-0003-1413-3974**

# About EviewsR

EviewsR is an R package that integrates R and EViews.

# Installation

EviewsR can be installed using the following commands in R.

``` r
install.packages("EviewsR") 

            OR
            
devtools::install_github('sagirumati/EviewsR')
```
# Setup

To run the package successfully, you need to rename the Eviews executable to `eviews` and then add the EViews installation folder to path. Alternatively, you can use `set_eviews_path` function to set the EViews path as follows:

```{r}
set_eviews_path("C:\\Program Files (x86)\\EViews 10\\EViews10.exe")
```

# Usage

Please load the EviewsR package as follows:

    ```{r EviewsR}                                                                .
    library(EviewsR)
    ```

Then create a chunk for Eviews as shown below:

```` 
```{eviews EviewsR1,eval=T,echo=T,comment=NULL,results='hide'}                .
    'This program is created in R Markdown with the help of EviewsR package
  %path=@runpath
  cd %path
  wfcreate(page=EviewsR) EviewsR m 1999 2020
  for %y Created By Sagiru Mati Northwest University Kano Nigeria
  pagecreate(page={%y}) EviewsR m 1999 2020
  wfsave EviewsR
  next
  pageselect Sagiru
  genr y=rnd
  genr x=rnd
  equation ols.ls y c x
  freeze(EviewsR_OLS,mode=overwrite) ols
  EviewsR_OLS.save(t=csv, r=r7c1:r10c5) EviewsROLS
  EviewsR_OLS.save(t=csv) EviewsRtable
  freeze(EviewsR_Plot,mode=overwrite) y.line
  EviewsR_Plot.save(t=png) EviewsR_Plot_color
  EviewsR_Plot.save(t=png,-c) EviewsR_Plot_nocolor
  exit
```  
````

The above chunk creates an Eviews program with the chunk’s content, then
automatically open Eviews and run the program, which will create an
Eviews workfile with pages containing monthly sample from 1999 to 2020.
The program will also save an Eviews workfile named `EviewsR` in the
current directory.

We can *dynamically and reproducibly* fetch the Eviews graph object we
created with the Eviews chunk using the following R chunk:

For the color graph object:

``` r
knitr::include_graphics("EviewsR_Plot_color.png")
```

<br><br><br><br>

or the black and white graph object:

``` r
knitr::include_graphics("EviewsR_Plot_nocolor.png")
```

we can also include the results of the OLS generated by the Eviews chunk
using the following R chunk;

For the OLS result only:

``` r
olsResult=read.csv("EviewsROLS.csv")
knitr::kable(olsResult)
```

<br><br><br><br>

or the entire OLS output:

``` r
olsTable=read.csv("EviewsRtable.csv")
knitr::kable(olsTable,format = "html")
```

<br><br><br><br>

Please see the example files for a better explanation.
